/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetSourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeFacetSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, PackagingSourceItem parent) {
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItemsProvider", "getSourceItems"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItemsProvider", "getSourceItems"));
        }
        ArrayList<JavaeeFacetSourceItem> items = new ArrayList<JavaeeFacetSourceItem>();
        if (parent instanceof ModuleSourceItemGroup) {
            for (JavaeeFacet javaeeFacet : JavaeeFacetSourceItemsProvider.getNotAddedFacets(editorContext, artifact, ((ModuleSourceItemGroup)parent).getModule())) {
                items.add(new JavaeeFacetSourceItem(javaeeFacet));
            }
        }
        ArrayList<JavaeeFacetSourceItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItemsProvider", "getSourceItems"));
        }
        return arrayList;
    }

    public static Collection<? extends JavaeeFacet> getNotAddedFacets(ArtifactEditorContext editorContext, Artifact artifact, Module ... modules) {
        HashSet<JavaeeFacet> facets = new HashSet<JavaeeFacet>(JavaeeFacetSourceItemsProvider.getAllJavaeeFacets(editorContext, modules));
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), element -> {
            facets.remove(element.findFacet((PackagingElementResolvingContext)editorContext));
            return true;
        }, (PackagingElementResolvingContext)editorContext, (boolean)true);
        return facets;
    }

    public static List<JavaeeFacet> getAllJavaeeFacets(ArtifactEditorContext editorContext, Module[] modules) {
        ArrayList<JavaeeFacet> facets = new ArrayList<JavaeeFacet>();
        for (Module module : modules) {
            for (FacetTypeId facetTypeId : JavaeeFacetUtil.getInstance().getAllJavaeeFacetTypes()) {
                facets.addAll(editorContext.getFacetsProvider().getFacetsByType(module, facetTypeId));
            }
        }
        return facets;
    }
}

