/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class JavaeeFacetNodePresentation
extends TreeNodePresentation {
    private final Facet myFacet;
    private final ArtifactEditorContext myContext;
    private final FacetPointer<JavaeeFacet> myFacetPointer;
    private String myKind;

    public JavaeeFacetNodePresentation(@NotNull ArtifactEditorContext context, @NotNull FacetPointer<JavaeeFacet> facetPointer, @NotNull String kind) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/ui/packaging/JavaeeFacetNodePresentation", "<init>"));
        }
        if (facetPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetPointer", "com/intellij/javaee/ui/packaging/JavaeeFacetNodePresentation", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/javaee/ui/packaging/JavaeeFacetNodePresentation", "<init>"));
        }
        this.myContext = context;
        this.myFacetPointer = facetPointer;
        this.myFacet = facetPointer.findFacet(context.getModulesProvider(), context.getFacetsProvider());
        this.myKind = kind;
    }

    public String getPresentableName() {
        return this.myFacetPointer.getFacetName(this.myContext.getModulesProvider(), this.myContext.getFacetsProvider());
    }

    public boolean canNavigateToSource() {
        return this.myFacet != null;
    }

    public void navigateToSource() {
        this.myContext.selectFacet(this.myFacet);
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/javaee/ui/packaging/JavaeeFacetNodePresentation", "render"));
        }
        String text = "'" + this.myFacetPointer.getModuleName(this.myContext.getModifiableModuleModel()) + "' module: '" + this.getPresentableName() + "' facet " + this.myKind;
        if (this.myFacet == null) {
            presentationData.addText(text, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else {
            presentationData.setIcon(this.myFacet.getType().getIcon());
            presentationData.addText(text, mainAttributes);
        }
    }

    public int getWeight() {
        return 10;
    }
}

