/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.ArchiveArtifactTemplate;
import com.intellij.javaee.ui.packaging.ExplodedArtifactForModulesTemplate;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeArtifactTypeBase
extends ArtifactType {
    private final boolean myArchive;
    private final FacetTypeId<? extends JavaeeFacet> myFacetTypeId;

    protected JavaeeArtifactTypeBase(@NonNls String id, String title, boolean isArchive, FacetTypeId<? extends JavaeeFacet> facetTypeId) {
        super(id, title);
        this.myArchive = isArchive;
        this.myFacetTypeId = facetTypeId;
    }

    public boolean isArchive() {
        return this.myArchive;
    }

    public FacetTypeId<? extends JavaeeFacet> getFacetTypeId() {
        return this.myFacetTypeId;
    }

    @Nullable
    protected VirtualFile findDescriptor(CompositePackagingElement<?> rootElement, ArtifactProblemsHolder manager, String relativePath) {
        List elements = ArtifactUtil.findByRelativePath(rootElement, (String)relativePath, (PackagingElementResolvingContext)manager.getContext(), (ArtifactType)this);
        if (elements.isEmpty()) {
            return null;
        }
        PackagingElement element = (PackagingElement)elements.get(0);
        if (!(element instanceof FileCopyPackagingElement)) {
            return null;
        }
        return ((FileCopyPackagingElement)element).findFile();
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/ui/packaging/JavaeeArtifactTypeBase", "getNewArtifactTemplates"));
        }
        if (this.myArchive) {
            Collection artifacts = context.getArtifactModel().getArtifactsByType(this.getExplodedArtifactType());
            ArrayList<ArchiveArtifactTemplate> result = new ArrayList<ArchiveArtifactTemplate>();
            for (Artifact artifact : artifacts) {
                result.add(new ArchiveArtifactTemplate(artifact, context, this));
            }
            ArrayList<ArchiveArtifactTemplate> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/JavaeeArtifactTypeBase", "getNewArtifactTemplates"));
            }
            return arrayList;
        }
        List<? extends ArtifactTemplate> list = this.getExplodedArtifactTemplates(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/JavaeeArtifactTypeBase", "getNewArtifactTemplates"));
        }
        return list;
    }

    protected List<? extends ArtifactTemplate> getExplodedArtifactTemplates(PackagingElementResolvingContext context) {
        if (!ExplodedArtifactForModulesTemplate.getModulesWithAppropriateFacets(this, context).isEmpty()) {
            return Collections.singletonList(new ExplodedArtifactForModulesTemplate(context, this));
        }
        return Collections.emptyList();
    }

    protected ArtifactType getExplodedArtifactType() {
        return this;
    }

    public static boolean isStandardJavaeeLibary(Library library) {
        LibrariesHelper manager = LibrariesHelper.getInstance();
        return manager.isClassAvailableInLibrary(library, "javax.servlet.Servlet") || manager.isClassAvailableInLibrary(library, "javax.servlet.jsp.JspPage") || manager.isClassAvailableInLibrary(library, "javax.ejb.SessionBean");
    }
}

