/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.forms.generator;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.NamedEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class GenerateInfo {
    private final String COMPONENT_FILE_SUFFIX = "Component";
    private final String FORM_FILE_SUFFIX = "Form";
    private String myName = "";
    private final Map<String, Pair<Class, String>> myName2Class = new HashMap<String, Pair<Class, String>>();
    private static final Map<Class, String> class2presentationClassName = new HashMap<Class, String>();

    GenerateInfo() {
    }

    public void putControlInfo(String name, Class clazz) {
        this.myName2Class.put(name, (Pair<Class, String>)new Pair((Object)clazz, (Object)this.getPresentationClassname(clazz)));
    }

    private String getPresentationClassname(Class clazz) {
        for (Class aClass : class2presentationClassName.keySet()) {
            if (!aClass.isAssignableFrom(clazz)) continue;
            return class2presentationClassName.get(aClass);
        }
        return "JLabel";
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getComponentClassName() {
        return this.myName + "Component";
    }

    public String getFormFileName() {
        return this.myName + "Form";
    }

    public Map<String, Pair<Class, String>> getName2Class() {
        return this.myName2Class;
    }

    static {
        class2presentationClassName.put(String.class, "JTextField");
        class2presentationClassName.put(Boolean.class, "JCheckBox");
        class2presentationClassName.put(Collection.class, "com.intellij.util.xml.ui.DomTableView");
        class2presentationClassName.put(NamedEnum.class, "JComboBox");
        class2presentationClassName.put(PsiClass.class, "com.intellij.openapi.ui.TextFieldWithBrowseButton");
    }
}

