/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.ui.DeploymentDescriptorsOwner;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentDescriptorsOwnerBase
implements DeploymentDescriptorsOwner {
    private static final Key<DescriptorsPathsInfo> DESCRIPTORS_PATHS_INFO_KEY = Key.create((String)"descriptors_paths_info");
    private final List<VirtualFile> myFilesToDelete;
    private final Map<ConfigFileMetaData, Pair<ConfigFileVersion, String>> myFiles;
    private final FacetEditorContext myFacetEditorContext;

    protected DeploymentDescriptorsOwnerBase(@NotNull FacetEditorContext facetEditorContext) {
        if (facetEditorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetEditorContext", "com/intellij/javaee/ui/DeploymentDescriptorsOwnerBase", "<init>"));
        }
        this.myFilesToDelete = new ArrayList<VirtualFile>();
        this.myFiles = new HashMap<ConfigFileMetaData, Pair<ConfigFileVersion, String>>();
        this.myFacetEditorContext = facetEditorContext;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myFacetEditorContext.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/DeploymentDescriptorsOwnerBase", "getModule"));
        }
        return module;
    }

    @Override
    public void deleteDescriptorFile(String url) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            this.myFilesToDelete.add(file);
        }
    }

    @Override
    public void clear(ConfigFileMetaData ... metaData) {
        for (ConfigFileMetaData data : metaData) {
            this.myFiles.remove(data);
        }
    }

    @NonNls
    protected String getBaseDirectoryName(ConfigFileMetaData metaData) {
        return "";
    }

    @Override
    public String suggestDescriptorUrl(File baseDirectory, ConfigFileMetaData metaData, ConfigFileInfoSet container) {
        String fileRelativePath;
        File baseDir;
        String baseDirectoryName = this.getBaseDirectoryName(metaData);
        if (baseDirectoryName.length() == 0) {
            baseDir = new File(baseDirectory, metaData.getDirectoryPath());
            fileRelativePath = metaData.getFileName();
        } else {
            baseDir = new File(baseDirectory, baseDirectoryName);
            fileRelativePath = metaData.getDirectoryPath() + "/" + metaData.getFileName();
        }
        String baseDirUrl = VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)baseDir.getAbsolutePath()));
        if (this.myFacetEditorContext == null) {
            return baseDirUrl + "/" + fileRelativePath;
        }
        UserDataHolder moduleData = ((FacetEditorContextBase)this.myFacetEditorContext).getSharedModuleData();
        DescriptorsPathsInfo pathsInfo = (DescriptorsPathsInfo)moduleData.getUserData(DESCRIPTORS_PATHS_INFO_KEY);
        if (pathsInfo == null) {
            pathsInfo = new DescriptorsPathsInfo(this.myFacetEditorContext);
            moduleData.putUserData(DESCRIPTORS_PATHS_INFO_KEY, (Object)pathsInfo);
        }
        return pathsInfo.suggestUrl(baseDirUrl, fileRelativePath, container);
    }

    @Override
    public boolean willCreateFile(String url) {
        for (Pair<ConfigFileVersion, String> pair : this.myFiles.values()) {
            if (!url.contains((CharSequence)pair.getSecond())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addDescriptorFile(String url, ConfigFileMetaData metaData, ConfigFileVersion version) {
        this.myFiles.put(metaData, (Pair<ConfigFileVersion, String>)Pair.create((Object)version, (Object)url));
    }

    private void clear() {
        this.myFilesToDelete.clear();
        this.myFiles.clear();
    }

    @Nullable
    public ConfigFileVersion getDescriptorVersion(ConfigFileMetaData metaData) {
        Pair<ConfigFileVersion, String> pair = this.myFiles.get(metaData);
        return pair != null ? (ConfigFileVersion)pair.getFirst() : null;
    }

    @Nullable
    public String getDescriptorUrl(ConfigFileMetaData metaData) {
        Pair<ConfigFileVersion, String> pair = this.myFiles.get(metaData);
        return pair != null ? (String)pair.getSecond() : null;
    }

    public void createAndDeleteFiles(Project project) {
        for (VirtualFile file : this.myFilesToDelete) {
            try {
                if (!file.isValid()) continue;
                file.delete((Object)this);
            }
            catch (IOException iOException) {}
        }
        ConfigFileFactory factory = ConfigFileFactory.getInstance();
        for (Map.Entry<ConfigFileMetaData, Pair<ConfigFileVersion, String>> entry : this.myFiles.entrySet()) {
            factory.createFile(project, (String)entry.getValue().getSecond(), (ConfigFileVersion)entry.getValue().getFirst(), false);
        }
        this.clear();
    }

    private static class DescriptorsPathsInfo {
        private final Map<String, ConfigFileInfoSet> myUsedUrls = new HashMap<String, ConfigFileInfoSet>();

        public DescriptorsPathsInfo(FacetEditorContext context) {
            Module module = context.getModule();
            for (FacetTypeId facetType : JavaeeFacetUtil.getInstance().getAllJavaeeFacetTypes()) {
                Collection facets = context.getFacetsProvider().getFacetsByType(module, facetType);
                for (JavaeeFacet facet : facets) {
                    ConfigFileInfoSet configuration = facet.getDescriptorsContainer().getConfiguration();
                    for (ConfigFileInfo configFileInfo : configuration.getConfigFileInfos()) {
                        this.put(configFileInfo.getUrl(), configuration);
                    }
                }
            }
        }

        public void put(String url, ConfigFileInfoSet container) {
            this.myUsedUrls.put(url, container);
        }

        public String suggestUrl(String baseDirUrl, String fileName, ConfigFileInfoSet container) {
            String url = baseDirUrl + "/" + fileName;
            int i = 2;
            while (!this.isAvailable(url, container)) {
                url = baseDirUrl + i + "/" + fileName;
                ++i;
            }
            this.put(url, container);
            return url;
        }

        private boolean isAvailable(String url, ConfigFileInfoSet container) {
            ConfigFileInfoSet old = this.myUsedUrls.get(url);
            return old == null || old == container;
        }
    }
}

