/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportManagerConfigurableListener;
import com.intellij.javaee.transport.TransportType;
import com.intellij.javaee.transport.local.LocalTransportService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class TransportManagerConfigurable {
    private JComboBox myTypeComboBox;
    private ComboboxWithBrowseButton myHostComboBox;
    private JPanel myMainPanel;
    private final TransportManager myManager;
    private final List<TransportManagerConfigurableListener> myListeners;
    private Project myProject;

    public TransportManagerConfigurable() {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myManager = TransportManager.getInstance();
        this.myTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((TransportType)value).getName());
                }
                return this;
            }
        });
        this.myTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TransportManagerConfigurable.this.doResetHosts(TransportManagerConfigurable.this.getType() == LocalTransportService.TYPE ? LocalTransportService.HOST : null);
                }
            }
        });
        this.myHostComboBox.getComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((TransportHost)value).getName());
                }
                return this;
            }
        });
        this.myHostComboBox.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TransportManagerConfigurable.this.doNotifyListeners();
            }
        });
        this.myHostComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransportManagerConfigurable.this.doEditHosts();
            }
        });
        this.myTypeComboBox.setModel(new CollectionComboBoxModel(this.myManager.getTypes(), null));
    }

    private void doEditHosts() {
        TransportType type = this.getType();
        if (type == null) {
            return;
        }
        TransportHost oldSelectedHost = this.getHost();
        TransportHost newSelectedHost = this.myManager.editHostsOfType(type, oldSelectedHost);
        if (newSelectedHost == null) {
            this.doResetHosts(oldSelectedHost);
            return;
        }
        this.myTypeComboBox.setSelectedItem(newSelectedHost.getType());
        this.doResetHosts(newSelectedHost);
    }

    private void doNotifyListeners() {
        for (TransportManagerConfigurableListener listener : this.myListeners) {
            listener.hostSelectionChanged();
        }
    }

    private void doResetHosts(TransportHost selectedHost) {
        TransportType type = this.getType();
        List<TransportHost> items = type == null ? Collections.emptyList() : this.myManager.getHostsOfType(type, this.myProject);
        TransportHost selectedItem = null;
        if (selectedHost != null) {
            for (TransportHost item : items) {
                if (!item.getId().equals(selectedHost.getId())) continue;
                selectedItem = item;
                break;
            }
        }
        this.myHostComboBox.getComboBox().setModel(new CollectionComboBoxModel(items, selectedItem));
        this.doNotifyListeners();
    }

    public void setHostId(String hostId, @Nullable Project project) {
        this.myProject = project;
        TransportHost host = this.myManager.findHost(hostId, this.myProject);
        this.myTypeComboBox.setSelectedItem(host == null ? null : host.getType());
        this.myHostComboBox.getComboBox().setSelectedItem(host);
    }

    private TransportType getType() {
        return (TransportType)this.myTypeComboBox.getSelectedItem();
    }

    public TransportHost getHost() {
        return (TransportHost)this.myHostComboBox.getComboBox().getSelectedItem();
    }

    @Nullable
    public String getHostId() {
        TransportHost host = this.getHost();
        return host == null ? null : host.getId();
    }

    public void addListener(TransportManagerConfigurableListener listener) {
        this.myListeners.add(listener);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("Form.TransportManagerConfigurable.type"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("Form.TransportManagerConfigurable.host"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

