/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javaee.toolwindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotatedMembersNode<T extends PsiMember>
extends PsiMemberSimpleNode<T> {
    private Module myModule;
    protected PsiMember myMember;

    public AnnotatedMembersNode(@NotNull Module module, @NotNull T member, SimpleNode parent) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/toolwindow/tree/nodes/AnnotatedMembersNode", "<init>"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/javaee/toolwindow/tree/nodes/AnnotatedMembersNode", "<init>"));
        }
        super(parent, member);
        this.myModule = module;
        this.myMember = member;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        if (!this.myMember.isValid()) {
            return;
        }
        PsiClass psiClass = this.myMember.getContainingClass();
        presentation.clear();
        presentation.setTooltip(psiClass != null ? psiClass.getQualifiedName() : null);
        presentation.setIcon(this.myMember.getIcon(2));
        presentation.addText(this.getMemberName(), this.getPlainAttributes());
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            presentation.addText(" (" + qualifiedName + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getQualifiedName() {
        PsiClass psiClass = this.myMember.getContainingClass();
        if (psiClass != null && !this.myMember.equals(psiClass)) {
            return psiClass.getName();
        }
        return null;
    }

    @Nullable
    protected String getMemberName() {
        return this.myMember.getName();
    }

    public SimpleNode[] getChildren() {
        return new SimpleNode[0];
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myMember};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/toolwindow/tree/nodes/AnnotatedMembersNode", "getEqualityObjects"));
        }
        return objectArray;
    }
}

