/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider.appServers;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServers.ApplicationServerPanel;
import com.intellij.javaee.appServers.supportProvider.AddAppServerSupportUtil;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.supportProvider.appServers.AppServerFrameworkLibrariesFetcher;
import com.intellij.javaee.supportProvider.appServers.AppServerFrameworkLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ParameterizedRunnable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppServerSupportConfigurable
extends FrameworkSupportInModuleConfigurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.supportProvider.appServers.AppServerSupportConfigurable");
    private final FrameworkSupportModel myFrameworkSupportModel;
    private boolean myInitialized;
    private final ApplicationServerPanel myPanel = new ApplicationServerPanel();
    private ApplicationServer myLastSelection;

    public AppServerSupportConfigurable(FrameworkSupportModel model) {
        this.myFrameworkSupportModel = model;
    }

    public void onFrameworkSelectionChanged(boolean selected) {
        if (selected && !this.myInitialized) {
            this.myInitialized = true;
            this.myPanel.initialize();
            this.myPanel.addServerSelectionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppServerSupportConfigurable.this.onServerChanged(AppServerSupportConfigurable.this.myPanel.getSelectedServer());
                }
            });
        }
        this.onServerChanged(selected ? this.myPanel.getSelectedServer() : null);
    }

    private void onServerChanged(@Nullable ApplicationServer server) {
        AppServerLibrariesProvider provider;
        if (Comparing.equal((Object)server, (Object)this.myLastSelection)) {
            return;
        }
        AppServerLibrariesProvider appServerLibrariesProvider = provider = server != null ? AppServerSupportConfigurable.createLibraryProvider(server) : null;
        if (provider == null) {
            ((FrameworkSupportModelBase)this.myFrameworkSupportModel).setLibraryProvider(null);
        } else {
            AppServerFrameworkLibrariesFetcher.fetchLibraries(provider, (ParameterizedRunnable<Map<FrameworkType, List<File>>>)((ParameterizedRunnable)map -> {
                if (server.equals(this.myLastSelection)) {
                    ((FrameworkSupportModelBase)this.myFrameworkSupportModel).setLibraryProvider((FrameworkLibraryProvider)new AppServerFrameworkLibraryProvider(server, (Map<FrameworkType, List<File>>)map));
                }
            }));
        }
        this.myLastSelection = server;
    }

    public JComponent createComponent() {
        return this.myPanel.getPanel();
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/supportProvider/appServers/AppServerSupportConfigurable", "addSupport"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/supportProvider/appServers/AppServerSupportConfigurable", "addSupport"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/javaee/supportProvider/appServers/AppServerSupportConfigurable", "addSupport"));
        }
        ApplicationServer server = this.myPanel.getSelectedServer();
        if (server != null) {
            RunnerAndConfigurationSettings settings = AppServerSupportConfigurable.addSupport(model, server);
            JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)this.myFrameworkSupportModel).setRunConfiguration((CommonModel)settings.getConfiguration());
        }
    }

    @Nullable
    private static AppServerLibrariesProvider createLibraryProvider(@NotNull ApplicationServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/supportProvider/appServers/AppServerSupportConfigurable", "createLibraryProvider"));
        }
        AppServerIntegration integration = server.getSourceIntegration();
        ApplicationServerPersistentData persistentData = server.getPersistentData();
        if (integration == null || persistentData == null) {
            return null;
        }
        return integration.createLibrariesProvider(persistentData);
    }

    public static RunnerAndConfigurationSettings addSupport(ModifiableRootModel model, @NotNull ApplicationServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/supportProvider/appServers/AppServerSupportConfigurable", "addSupport"));
        }
        AppServerIntegration integration = server.getSourceIntegration();
        LOG.assertTrue(integration != null);
        ConfigurationFactory factory = ApplicationServerPanel.findLocalConfigurationFactory(integration);
        LOG.assertTrue(factory != null);
        AddAppServerSupportUtil.markAppServerAsUsed(server);
        Library serverLibrary = server.getLibrary();
        if (model.findLibraryOrderEntry(serverLibrary) == null) {
            model.addLibraryEntry(serverLibrary).setScope(DependencyScope.PROVIDED);
        }
        return J2EEConfigurationFactory.getInstance().addAppServerConfiguration(model.getProject(), factory, server);
    }
}

