/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.DeploysArtifactsOnStartupOnly;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.update.HotSwapClassesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.RedeployArtifactsUpdatingPolicy;
import com.intellij.javaee.run.execution.update.ReloadClassesAndResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.ReloadResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.RestartServerUpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatingRunningApplicationUtil {
    private static final Logger LOG = Logger.getInstance(UpdatingRunningApplicationUtil.class);
    private static UpdatingPolicy[] ourPolicies;

    private UpdatingRunningApplicationUtil() {
    }

    @Nullable
    public static UpdatingPolicy findPolicy(@Nullable @NonNls String id) {
        if (id == null) {
            return null;
        }
        for (UpdatingPolicy updatingPolicy : UpdatingRunningApplicationUtil.getPolicies()) {
            if (!id.equals(updatingPolicy.getId())) continue;
            return updatingPolicy;
        }
        return null;
    }

    public static Collection<? extends UpdatingPolicy> getPolicies() {
        if (ourPolicies == null) {
            ourPolicies = new UpdatingPolicy[]{new HotSwapClassesUpdatingPolicy(), new ReloadResourcesUpdatingPolicy(), new ReloadClassesAndResourcesUpdatingPolicy(), new RedeployArtifactsUpdatingPolicy(), new RestartServerUpdatingPolicy()};
        }
        return Arrays.asList(ourPolicies);
    }

    public static Collection<? extends UpdatingPolicy> getAvailablePolicies(@Nullable Executor executor, @NotNull CommonModel commonModel, boolean onFrameDeactivation) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "getAvailablePolicies"));
        }
        ArrayList<UpdatingPolicy> result = new ArrayList<UpdatingPolicy>();
        for (UpdatingPolicy updatingPolicy : UpdatingRunningApplicationUtil.getPolicies()) {
            if (executor != null && !updatingPolicy.isAvailableForExecutor(executor) || !updatingPolicy.isAvailableForConfiguration(commonModel) || onFrameDeactivation && !updatingPolicy.isAvailableOnFrameDeactivation()) continue;
            result.add(updatingPolicy);
        }
        return result;
    }

    public static void makeClasses(@NotNull Project project, @NotNull CommonModel commonModel, @Nullable CompileStatusNotification listener, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "makeClasses"));
        }
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "makeClasses"));
        }
        UpdatingRunningApplicationUtil.startCompilation(project, (CompileScope)ArtifactCompileScope.createScopeForModulesInArtifacts((Project)project, (Collection)commonModel.getDeployedArtifacts()), listener, onFrameDeactivation);
    }

    public static void startCompilation(@NotNull Project project, @NotNull CompileScope compileScope, @Nullable CompileStatusNotification listener, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "startCompilation"));
        }
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "startCompilation"));
        }
        UpdatingRunningApplicationUtil.startCompilation(project, compileScope, listener, null, onFrameDeactivation);
    }

    public static void startCompilation(@NotNull Project project, @NotNull CompileScope compileScope, final @Nullable CompileStatusNotification listener, CompilerFilter compilerFilter, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "startCompilation"));
        }
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "startCompilation"));
        }
        HotSwapUI.getInstance((Project)project).dontPerformHotswapAfterThisCompilation();
        if (onFrameDeactivation) {
            CompileDriver.setCompilationStartedAutomatically((CompileScope)compileScope);
        }
        CompilerManager.getInstance((Project)project).make(compileScope, compilerFilter, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (listener != null) {
                    listener.finished(aborted, errors, warnings, compileContext);
                }
            }
        });
    }

    public static void makeClassesAndResources(Project project, CommonModel commonModel, CompileStatusNotification listener, boolean onFrameDeactivation) {
        ModuleCompileScope baseScope = ArtifactCompileScope.createScopeForModulesInArtifacts((Project)project, (Collection)commonModel.getDeployedArtifacts());
        UpdatingRunningApplicationUtil.startCompilation(project, ArtifactCompileScope.createScopeWithArtifacts((CompileScope)baseScope, (Collection)commonModel.getArtifactsToBuild()), listener, onFrameDeactivation);
    }

    public static boolean isResourcesReloadingSupported(CommonModel commonModel) {
        CommonStrategy strategy = (CommonStrategy)commonModel;
        DeploymentProvider deploymentProvider = strategy.getDeploymentProvider();
        if (deploymentProvider == null) {
            ServerModel serverModel = strategy.getServerModel();
            if (serverModel instanceof DeploysArtifactsOnStartupOnly) {
                return ((DeploysArtifactsOnStartupOnly)serverModel).isResourcesReloadingSupported();
            }
            return false;
        }
        List<Artifact> deployedArtifacts = strategy.getDeployedArtifacts();
        if (deployedArtifacts.isEmpty()) {
            return false;
        }
        for (Artifact artifact : deployedArtifacts) {
            if (deploymentProvider.isResourcesReloadingSupported(commonModel, artifact.getArtifactType())) continue;
            return false;
        }
        return true;
    }

    public static boolean makeAndHotSwap(final Project project, CommonModel commonModel, ProcessHandler processHandler, final @Nullable CompileStatusNotification listener, boolean makeClassesOnly, boolean onFrameDeactivation) {
        DebuggerSession session;
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebugProcess process = debuggerManager.getDebugProcess(processHandler);
        if (process != null && (session = debuggerManager.getSession(process)) != null) {
            CompileStatusNotification notification = new CompileStatusNotification(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    try {
                        if (!project.isDisposed()) {
                            HotSwapUI.getInstance((Project)project).reloadChangedClasses(session, false);
                        }
                    }
                    finally {
                        if (listener != null) {
                            listener.finished(aborted, errors, warnings, compileContext);
                        }
                    }
                }
            };
            if (makeClassesOnly) {
                UpdatingRunningApplicationUtil.makeClasses(project, commonModel, notification, onFrameDeactivation);
            } else {
                UpdatingRunningApplicationUtil.makeClassesAndResources(project, commonModel, notification, onFrameDeactivation);
            }
            return true;
        }
        return false;
    }

    public static void setupPolicyCombobox(JComboBox<UpdatingPolicy> combobox, CommonStrategy config, boolean onFrameDeactivation) {
        combobox.setRenderer((ListCellRenderer<UpdatingPolicy>)new ListCellRendererWrapper<UpdatingPolicy>(){

            public void customize(JList list, UpdatingPolicy value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("Do nothing");
                } else {
                    this.setText(UIUtil.removeMnemonic((String)value.getDescription()));
                }
            }
        });
        UpdatingRunningApplicationUtil.updatePolicyCombobox(combobox, config, onFrameDeactivation);
    }

    public static Executor getExecutor(J2EEProcess process) {
        return UpdatingRunningApplicationUtil.getExecutor(process.getCommonStrategy().getProject(), (ProcessHandler)process);
    }

    @NotNull
    public static Executor getExecutor(Project project, ProcessHandler processHandler) {
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebugProcess debugProcess = debuggerManager.getDebugProcess(processHandler);
        if (debugProcess != null && debuggerManager.getSession(debugProcess) != null) {
            Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
            if (executor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "getExecutor"));
            }
            return executor;
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (executor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "getExecutor"));
        }
        return executor;
    }

    public static boolean updatePolicyCombobox(JComboBox combobox, CommonModel model, boolean onFrameDeactivation) {
        Object oldSelection = combobox.getSelectedItem();
        combobox.removeAllItems();
        if (onFrameDeactivation) {
            combobox.addItem(null);
        }
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(null, model, onFrameDeactivation);
        for (UpdatingPolicy updatingPolicy : policies) {
            combobox.addItem(updatingPolicy);
        }
        combobox.setSelectedItem(oldSelection);
        if (combobox.getSelectedItem() == null && combobox.getItemCount() > 0) {
            combobox.setSelectedIndex(0);
        }
        return !policies.isEmpty();
    }

    public static void updateOpenedFilesAndStartCompilation(@NotNull Project project, List<Artifact> affectedArtifacts, @NotNull Runnable compileAction) {
        ArrayList<VirtualFile> files;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "updateOpenedFilesAndStartCompilation"));
        }
        if (compileAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileAction", "com/intellij/javaee/run/execution/update/UpdatingRunningApplicationUtil", "updateOpenedFilesAndStartCompilation"));
        }
        LOG.debug("Quick in-process updating of resource files started");
        FileDocumentManager.getInstance().saveAllDocuments();
        List paths = BuildManager.getInstance().getFilesChangedSinceLastCompilation(project);
        if (paths != null) {
            files = new ArrayList();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (String path : paths) {
                ContainerUtil.addIfNotNull(files, (Object)fileSystem.findFileByPath(path));
            }
            UpdatingRunningApplicationUtil.logFiles(files, "changed since last compilation");
        } else {
            files = Arrays.asList(FileEditorManager.getInstance((Project)project).getSelectedFiles());
            UpdatingRunningApplicationUtil.logFiles(files, "opened in the editor");
        }
        if (files.isEmpty()) {
            compileAction.run();
        } else {
            PackageFileWorker.startPackagingFiles((Project)project, files, (Artifact[])affectedArtifacts.toArray(new Artifact[affectedArtifacts.size()]), (Runnable)compileAction);
        }
    }

    private static void logFiles(List<VirtualFile> files, String description) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating " + files.size() + " files, " + description);
            for (VirtualFile file : files) {
                LOG.debug(" " + file.getPath());
            }
        }
    }
}

