/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredByFileTypeCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final CompileScope myDelegate;
    private final FileType[] myExcludedFileTypes;
    private final FileTypeManager myFileTypeManager;

    public FilteredByFileTypeCompileScope(CompileScope delegate, FileType ... excludedFileTypes) {
        this.myDelegate = delegate;
        this.myExcludedFileTypes = excludedFileTypes;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @NotNull
    public VirtualFile[] getFiles(@Nullable FileType fileType, boolean inSourceOnly) {
        VirtualFile[] files = this.myDelegate.getFiles(fileType, inSourceOnly);
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (ArrayUtil.contains((Object)file.getFileType(), (Object[])this.myExcludedFileTypes)) continue;
            filtered.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(filtered);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/update/FilteredByFileTypeCompileScope", "getFiles"));
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        String name = url.substring(url.lastIndexOf(47) + 1);
        return !ArrayUtil.contains((Object)this.myFileTypeManager.getFileTypeByFileName(name), (Object[])this.myExcludedFileTypes) && this.myDelegate.belongs(url);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] moduleArray = this.myDelegate.getAffectedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/update/FilteredByFileTypeCompileScope", "getAffectedModules"));
        }
        return moduleArray;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/javaee/run/execution/update/FilteredByFileTypeCompileScope", "getUserData"));
        }
        Object data = this.myDelegate.getUserData(key);
        if (data != null) {
            return (T)data;
        }
        return (T)super.getUserData(key);
    }
}

