/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.RunnerSpecificLocalConfigurationBit;
import com.intellij.javaee.run.execution.ExecutionHelper;
import com.intellij.javaee.run.execution.J2EELocalProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EERunnableState;
import com.intellij.javaee.run.execution.LocalJavaeeServerProcessHandler;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ScriptInfo;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Key;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PatchedLocalState
implements PatchedRunnableState,
J2EERunnableState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.run.state.PatchedLocalState");
    private final RunnerSpecificLocalConfigurationBit myRunnerSpec;
    private final CommonStrategy myConfiguration;
    private final RunnerSettings myRunnerSettings;
    private final ExecutionHelper myExecutionHelper;

    public PatchedLocalState(RunnerSpecificLocalConfigurationBit runnerSpec, CommonStrategy configuration, RunnerSettings runnerSettings, ExecutionHelper executionHelper) {
        this.myRunnerSpec = runnerSpec;
        this.myConfiguration = configuration;
        this.myRunnerSettings = runnerSettings;
        this.myExecutionHelper = executionHelper;
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javaee/run/execution/PatchedLocalState", "execute"));
        }
        J2EEServerInstance serverInstance = this.myExecutionHelper.createServerInstance();
        J2EELocalProcessHandlerWrapper processHandlerWrapper = new J2EELocalProcessHandlerWrapper(serverInstance, executor, this.myConfiguration, this);
        return this.myExecutionHelper.createExecutionResult(processHandlerWrapper, executor);
    }

    @Override
    public J2EEProcess startJ2EEProcess(J2EEProcessHandlerWrapper processHandlerWrapper) throws ExecutionException {
        try {
            this.myExecutionHelper.checkAddressesAlreadyInUse(processHandlerWrapper);
            this.myRunnerSpec.getStartupInfo().initRunnerSettings((RunConfigurationBase)this.myRunnerSpec.getParentConfiguration(), this.myRunnerSettings);
            this.myRunnerSpec.getShutdownInfo().initRunnerSettings((RunConfigurationBase)this.myRunnerSpec.getParentConfiguration(), this.myRunnerSettings);
            ExecutableObject script = this.myRunnerSpec.getStartupInfo().getScript();
            if (script == null) {
                throw new ExecutionException(J2EEBundle.message((String)"exception.text.startup.script.is.not.specified", (Object[])new Object[0]));
            }
            J2EEServerInstance serverInstance = processHandlerWrapper.getServerInstance();
            boolean startupScriptTerminatesAfterServerStartup = serverInstance instanceof DefaultServerInstance && ((DefaultServerInstance)serverInstance).isStartupScriptTerminatesAfterServerStartup(script);
            OSProcessHandler startupHandler = script.createProcessHandler(this.myConfiguration.getWorkingDirectory(), this.getEnvParams(this.myRunnerSpec.getStartupInfo(), true));
            ScriptBasedLocalJavaeeServerProcessHandler result = new ScriptBasedLocalJavaeeServerProcessHandler(processHandlerWrapper.createHelper(), startupHandler, startupScriptTerminatesAfterServerStartup);
            processHandlerWrapper.connectToProcess();
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)processHandlerWrapper, this.myRunnerSettings);
            return result;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new ExecutionException(J2EEBundle.message((String)"message.text.error.running.configuration.exception.occured.with.message", (Object[])new Object[]{this.myConfiguration.getIntegration().getPresentableName(), e.getClass().getName(), e.getMessage()}));
        }
    }

    private Map<String, String> getEnvParams(ScriptInfo scriptInfo, boolean addPredefinedVars) throws ExecutionException {
        return (Map)ReadAction.compute(() -> this.calcEnvParams(scriptInfo, addPredefinedVars));
    }

    @NotNull
    private Map<String, String> calcEnvParams(ScriptInfo scriptInfo, boolean addPredefinedVars) throws ExecutionException {
        EnvironmentHelper environmentHelper;
        Object envVariables;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.myRunnerSpec.USE_ENV_VARIABLES) {
            JavaParameters javaParameters = this.myRunnerSpec.createJavaParameters();
            this.myRunnerSpec.getRunner().patch(javaParameters, this.myRunnerSettings, (RunProfile)this.myRunnerSpec.getParentConfiguration(), true);
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                ext.updateJavaParameters((RunConfigurationBase)this.myConfiguration, javaParameters, this.myRunnerSettings);
            }
            result.putAll(javaParameters.getEnv());
            envVariables = this.myRunnerSpec.getEnvVarValues(scriptInfo, addPredefinedVars, this.myRunnerSpec.appendVMArguments(javaParameters));
            result.putAll((Map<String, String>)envVariables);
        }
        if ((environmentHelper = this.myConfiguration.getHelper()) != null && (envVariables = environmentHelper.getAdditionalEnvironmentVariables((CommonModel)this.myConfiguration)) != null) {
            Iterator iterator = envVariables.iterator();
            while (iterator.hasNext()) {
                EnvironmentVariable variable = (EnvironmentVariable)iterator.next();
                if (result.containsKey(variable.getName())) continue;
                result.put(variable.getName(), variable.getValue());
            }
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/PatchedLocalState", "calcEnvParams"));
        }
        return hashMap;
    }

    private class ScriptBasedLocalJavaeeServerProcessHandler
    extends LocalJavaeeServerProcessHandler {
        public ScriptBasedLocalJavaeeServerProcessHandler(J2EEProcessHandlerHelper helper, OSProcessHandler startupHandler, boolean startupScriptTerminatesAfterServerStartup) {
            super(helper, startupHandler, startupScriptTerminatesAfterServerStartup);
        }

        @Override
        protected void onBaseProcessTerminated() {
        }

        @Override
        public void shutdown() {
            ExecutableObject shutdownScript = PatchedLocalState.this.myRunnerSpec.getShutdownInfo().getScript();
            if (shutdownScript == null) {
                this.myStartupHandler.destroyProcess();
                return;
            }
            try {
                OSProcessHandler processHandler = shutdownScript.createProcessHandler(PatchedLocalState.this.myConfiguration.getWorkingDirectory(), PatchedLocalState.this.getEnvParams(PatchedLocalState.this.myRunnerSpec.getShutdownInfo(), false));
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        ScriptBasedLocalJavaeeServerProcessHandler.this.notifyTextAvailable(event.getText(), outputType);
                    }

                    public void processTerminated(ProcessEvent event) {
                        if (ScriptBasedLocalJavaeeServerProcessHandler.this.myStartupScriptTerminatesAfterServerStartup) {
                            ScriptBasedLocalJavaeeServerProcessHandler.this.terminateAndNotify();
                        }
                    }
                });
                processHandler.startNotify();
            }
            catch (ExecutionException e) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(buffer));
                try {
                    this.myStartupHandler.notifyTextAvailable(buffer.toString(this.myStartupHandler.getCharset().name()), ProcessOutputTypes.STDERR);
                }
                catch (UnsupportedEncodingException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }
    }
}

