/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.run.execution.J2EERunnableState;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2EEProcessHandlerWrapper
extends ProcessHandler
implements J2EEProcess {
    private static final Logger LOG = Logger.getInstance((String)("#" + J2EEProcessHandlerWrapper.class.getName()));
    private final J2EEServerInstance myServerInstance;
    private final CommonStrategy myConfiguration;
    private final boolean myRemote;
    private final String myToolWindowId;
    private final Semaphore myStartSemaphore;
    private final EventDispatcher<ProcessListener> myEventDispatcher;
    private final ProcessListener myEventMulticaster;
    private final ExecutorService myWrappedProcessExecutor;
    private final OutputStream myOutputStream;
    private boolean myStartDone;
    private boolean myStartSuccessful;
    private ProcessHandler myWrappedProcessHandler;
    private J2EEProcess myWrappedJ2EEProcess;

    public J2EEProcessHandlerWrapper(J2EEServerInstance serverInstance, Executor executor, @NotNull CommonStrategy configuration, @NotNull J2EERunnableState runnableState, boolean remote) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/run/execution/J2EEProcessHandlerWrapper", "<init>"));
        }
        if (runnableState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnableState", "com/intellij/javaee/run/execution/J2EEProcessHandlerWrapper", "<init>"));
        }
        this.myWrappedProcessExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"J2EEProcessHandlerWrapper pool");
        this.myServerInstance = serverInstance;
        this.myConfiguration = configuration;
        this.myRemote = remote;
        this.myToolWindowId = executor.getToolWindowId();
        this.myStartSemaphore = new Semaphore();
        this.myStartSemaphore.down();
        this.myStartDone = false;
        this.myStartSuccessful = false;
        this.myEventDispatcher = EventDispatcher.create(ProcessListener.class);
        this.myEventMulticaster = (ProcessListener)this.myEventDispatcher.getMulticaster();
        BuildManager.ALLOW_AUTOMAKE.set((UserDataHolder)this, (Object)Boolean.TRUE);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                J2EEProcessHandlerWrapper.this.myWrappedProcessExecutor.shutdownNow();
            }
        });
        this.myWrappedProcessExecutor.submit(() -> {
            if (runnableState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnableState", "com/intellij/javaee/run/execution/J2EEProcessHandlerWrapper", "lambda$new$0"));
            }
            try {
                if (this.myServerInstance instanceof DefaultServerInstance) {
                    ((DefaultServerInstance)this.myServerInstance).prepare();
                }
                this.myWrappedJ2EEProcess = runnableState.startJ2EEProcess(this);
                this.myWrappedProcessHandler = (ProcessHandler)this.myWrappedJ2EEProcess;
                this.myWrappedProcessHandler.addProcessListener(new ProcessListener(){

                    private ProcessEvent wrapProcessEvent(ProcessEvent event) {
                        String text = event.getText();
                        return text == null ? new ProcessEvent((ProcessHandler)J2EEProcessHandlerWrapper.this, event.getExitCode()) : new ProcessEvent((ProcessHandler)J2EEProcessHandlerWrapper.this, text);
                    }

                    public void startNotified(ProcessEvent event) {
                        J2EEProcessHandlerWrapper.this.myEventMulticaster.startNotified(this.wrapProcessEvent(event));
                    }

                    public void processTerminated(ProcessEvent event) {
                        J2EEProcessHandlerWrapper.this.myEventMulticaster.processTerminated(this.wrapProcessEvent(event));
                    }

                    public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                        J2EEProcessHandlerWrapper.this.myEventMulticaster.processWillTerminate(this.wrapProcessEvent(event), willBeDestroyed);
                    }

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        J2EEProcessHandlerWrapper.this.myEventMulticaster.onTextAvailable(this.wrapProcessEvent(event), outputType);
                    }
                });
                this.myStartSuccessful = true;
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)this.getProject(), (String)this.myToolWindowId, (RunProfile)this.myConfiguration, (ExecutionException)e);
                this.myEventMulticaster.processWillTerminate(new ProcessEvent((ProcessHandler)this), true);
                this.myEventMulticaster.processTerminated(new ProcessEvent((ProcessHandler)this));
            }
            finally {
                this.myStartDone = true;
                this.myStartSemaphore.up();
            }
        });
        this.myOutputStream = remote ? null : new OutputStreamWrapper();
    }

    private Project getProject() {
        return this.myConfiguration.getProject();
    }

    public void showWarning(String message) {
        NotificationGroup.toolWindowGroup((String)"JavaEE", (String)this.myToolWindowId).createNotification(message, NotificationType.WARNING).notify(this.getProject());
    }

    public void startNotify() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.startNotify();
            }
        };
    }

    public boolean waitFor() {
        this.myStartSemaphore.waitFor();
        if (this.myStartSuccessful) {
            return this.myWrappedProcessHandler.waitFor();
        }
        return true;
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        int TIMEOUT_STEP = 10;
        while (true) {
            if (this.myStartSuccessful) {
                return this.myWrappedProcessHandler.waitFor(timeoutInMilliseconds);
            }
            this.myStartSemaphore.waitFor(10L);
            if (timeoutInMilliseconds <= 10L) break;
            timeoutInMilliseconds -= 10L;
        }
        return true;
    }

    public void destroyProcess() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.destroyProcess();
            }
        };
    }

    public void detachProcess() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.detachProcess();
            }
        };
    }

    public boolean isProcessTerminated() {
        return new StartSwitch(){

            @Override
            protected boolean onStartSuccess() {
                return J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.isProcessTerminated();
            }

            @Override
            protected boolean onStartError() {
                return true;
            }
        }.doSwitch();
    }

    public boolean isProcessTerminating() {
        return new StartSwitch(){

            @Override
            protected boolean onStartSuccess() {
                return J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.isProcessTerminating();
            }
        }.doSwitch();
    }

    @Nullable
    public Integer getExitCode() {
        return this.myWrappedProcessHandler.getExitCode();
    }

    public void addProcessListener(ProcessListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeProcessListener(ProcessListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    protected void notifyProcessDetached() {
        throw new UnsupportedOperationException();
    }

    protected void notifyProcessTerminated(int exitCode) {
        throw new UnsupportedOperationException();
    }

    public void notifyTextAvailable(final String text, final Key outputType) {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.notifyTextAvailable(text, outputType);
            }
        };
    }

    public boolean isStartNotified() {
        return this.myStartSuccessful && this.myWrappedProcessHandler.isStartNotified();
    }

    protected void destroyProcessImpl() {
        throw new UnsupportedOperationException();
    }

    protected void detachProcessImpl() {
        throw new UnsupportedOperationException();
    }

    public boolean detachIsDefault() {
        return this.myRemote;
    }

    public OutputStream getProcessInput() {
        return this.myOutputStream;
    }

    @Override
    public void invokeTerminate() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedJ2EEProcess.invokeTerminate();
            }
        };
    }

    @Override
    public void terminate() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedJ2EEProcess.terminate();
            }
        };
    }

    @Override
    public void started() {
        new ProcessCall(){

            @Override
            public void onProcess() {
                J2EEProcessHandlerWrapper.this.myWrappedJ2EEProcess.started();
            }
        };
    }

    @Override
    public CommonStrategy getCommonStrategy() {
        return this.myConfiguration;
    }

    @Override
    public J2EEServerInstance getServerInstance() {
        return this.myServerInstance;
    }

    public boolean connectToProcess() throws Exception {
        this.myServerInstance.start((ProcessHandler)this);
        return this.myServerInstance.connect();
    }

    protected final ProcessHandler getWrappedProcessHandler() {
        return this.myWrappedProcessHandler;
    }

    public J2EEProcessHandlerHelper createHelper() {
        return new J2EEProcessHandlerHelper(this.myServerInstance, this.myConfiguration, this);
    }

    protected abstract class StartSwitch {
        protected StartSwitch() {
        }

        public boolean doSwitch() {
            if (J2EEProcessHandlerWrapper.this.myStartDone) {
                if (J2EEProcessHandlerWrapper.this.myStartSuccessful) {
                    return this.onStartSuccess();
                }
                return this.onStartError();
            }
            return false;
        }

        protected abstract boolean onStartSuccess();

        protected boolean onStartError() {
            return false;
        }
    }

    private class OutputStreamWrapper
    extends OutputStream {
        private OutputStreamWrapper() {
        }

        private OutputStream getWrappedProcessInput() {
            return J2EEProcessHandlerWrapper.this.myWrappedProcessHandler.getProcessInput();
        }

        @Override
        public void write(final @NotNull byte[] b) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/javaee/run/execution/J2EEProcessHandlerWrapper$OutputStreamWrapper", "write"));
            }
            new OutputCall(){

                @Override
                protected void onOutput() throws IOException {
                    OutputStreamWrapper.this.getWrappedProcessInput().write(b);
                }
            };
        }

        @Override
        public void write(final @NotNull byte[] b, final int off, final int len) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/javaee/run/execution/J2EEProcessHandlerWrapper$OutputStreamWrapper", "write"));
            }
            new OutputCall(){

                @Override
                protected void onOutput() throws IOException {
                    OutputStreamWrapper.this.getWrappedProcessInput().write(b, off, len);
                }
            };
        }

        @Override
        public void flush() throws IOException {
            new OutputCall(){

                @Override
                protected void onOutput() throws IOException {
                    OutputStreamWrapper.this.getWrappedProcessInput().flush();
                }
            };
        }

        @Override
        public void close() throws IOException {
            new OutputCall(){

                @Override
                protected void onOutput() throws IOException {
                    OutputStreamWrapper.this.getWrappedProcessInput().close();
                }
            };
        }

        @Override
        public void write(final int b) throws IOException {
            new OutputCall(){

                @Override
                protected void onOutput() throws IOException {
                    OutputStreamWrapper.this.getWrappedProcessInput().write(b);
                }
            };
        }

        abstract class OutputCall
        extends ProcessCall {
            OutputCall() {
            }

            @Override
            public void onProcess() {
                try {
                    this.onOutput();
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }

            protected abstract void onOutput() throws IOException;
        }
    }

    protected abstract class ProcessCall {
        public ProcessCall() {
            J2EEProcessHandlerWrapper.this.myWrappedProcessExecutor.submit(() -> {
                if (J2EEProcessHandlerWrapper.this.myStartSuccessful) {
                    this.onProcess();
                } else {
                    this.onStartError();
                }
            });
        }

        public abstract void onProcess();

        public void onStartError() {
        }
    }
}

