/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.run.configuration.RunnerSpecificLocalConfigurationBit;
import com.intellij.javaee.run.localRun.ScriptInfo;
import com.intellij.javaee.run.localRun.ScriptPanel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class RunnerSpecificLocalPanel
extends SettingsEditor<ConfigurationPerRunnerSettings> {
    private JPanel myEnvironmentVariablesPanel;
    private JPanel myPanel;
    private JCheckBox myPassEnvironmentVariables;
    private final EnvVariablesTable myEnvVariablesTable;
    private JPanel myShutdownScriptPanel;
    private JPanel myStartupScriptPanel;
    private final ScriptPanel myStartup;
    private final ScriptPanel myShutdown;

    public RunnerSpecificLocalPanel() {
        this.$$$setupUI$$$();
        this.myStartup = new ScriptPanel(true);
        this.myShutdown = new ScriptPanel(false);
        this.myPassEnvironmentVariables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunnerSpecificLocalPanel.this.enableControls();
            }
        });
        this.myEnvVariablesTable = new EnvVariablesTable();
        this.myEnvironmentVariablesPanel.setLayout(new BorderLayout());
        this.myEnvironmentVariablesPanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
        this.myShutdownScriptPanel.setLayout(new BorderLayout());
        this.myShutdownScriptPanel.add((Component)this.myShutdown.getComponent(), "Center");
        this.myStartupScriptPanel.setLayout(new BorderLayout());
        this.myStartupScriptPanel.add((Component)this.myStartup.getComponent(), "Center");
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                RunnerSpecificLocalPanel.this.fireEditorStateChanged();
            }
        };
        this.myStartup.addObserver(observer);
        this.myShutdown.addObserver(observer);
    }

    public void editEnvironmentVariableName(EnvironmentVariable environmentVariable) {
        this.myEnvVariablesTable.editVariableName(environmentVariable);
    }

    public void resetEditorFrom(ConfigurationPerRunnerSettings item) {
        RunnerSpecificLocalConfigurationBit localItem = (RunnerSpecificLocalConfigurationBit)item;
        this.myPassEnvironmentVariables.setSelected(localItem.USE_ENV_VARIABLES);
        ScriptInfo shutdownInfo = localItem.getShutdownInfo();
        shutdownInfo.initRunnerSettings((RunConfigurationBase)localItem.getParentConfiguration(), localItem.getRunnerSettings());
        this.myShutdown.updateFrom(shutdownInfo, localItem.getParentConfiguration());
        ScriptInfo startupInfo = localItem.getStartupInfo();
        startupInfo.initRunnerSettings((RunConfigurationBase)localItem.getParentConfiguration(), localItem.getRunnerSettings());
        this.myStartup.updateFrom(startupInfo, localItem.getParentConfiguration());
        this.myEnvVariablesTable.setValues(localItem.getEnvVariables());
        this.enableControls();
    }

    public void applyEditorTo(ConfigurationPerRunnerSettings item) {
        RunnerSpecificLocalConfigurationBit localItem = (RunnerSpecificLocalConfigurationBit)item;
        localItem.USE_ENV_VARIABLES = this.myPassEnvironmentVariables.isSelected();
        this.myShutdown.applyTo(localItem.getShutdownInfo());
        this.myStartup.applyTo(localItem.getStartupInfo());
        localItem.setEnvironmentVariables(this.myEnvVariablesTable.getEnvironmentVariables());
        this.myEnvVariablesTable.refreshValues();
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/view/RunnerSpecificLocalPanel", "createEditor"));
        }
        return jPanel;
    }

    private void enableControls() {
        if (this.myPassEnvironmentVariables.isSelected()) {
            this.myEnvVariablesTable.setEnabled();
        } else {
            this.myEnvVariablesTable.setDisabled();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.run.configuration.editor.startup.script"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartupScriptPanel = jPanel3 = new JPanel();
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(100, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.run.configuration.editor.shutdown.script"));
        jPanel5.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShutdownScriptPanel = jPanel2 = new JPanel();
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(100, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/J2EEBundle").getString("border.run.configuration.editor.environment.variables"), (int)0, (int)0, null, null));
        this.myPassEnvironmentVariables = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.run.configuration.editor.pass.environment.variables"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnvironmentVariablesPanel = jPanel = new JPanel();
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 50), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

