/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.configuration.ServerModelEx;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class J2EEConfigurationFactoryImpl
extends J2EEConfigurationFactory {
    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, JavaCommandLineStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, ExecutableObjectStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunnerAndConfigurationSettings addAppServerConfiguration(@NotNull Project project, @NotNull ConfigurationFactory type, @NotNull ApplicationServer appServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "addAppServerConfiguration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "addAppServerConfiguration"));
        }
        if (appServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appServer", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "addAppServerConfiguration"));
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(appServer.getName(), type);
        CommonStrategy configuration = (CommonStrategy)runSettings.getConfiguration();
        configuration.setApplicationServer(appServer);
        runManager.addConfiguration(runSettings, false);
        runManager.setSelectedConfiguration(runSettings);
        return runSettings;
    }

    public RunnerAndConfigurationSettings createSettingsByFile(@NotNull PsiFile psiFile, @NotNull J2EEConfigurationType configurationType) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "createSettingsByFile"));
        }
        if (configurationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationType", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "createSettingsByFile"));
        }
        AppServerIntegration integration = configurationType.getIntegration();
        if (integration == null) {
            return null;
        }
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration});
        if (servers.isEmpty()) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType != StdFileTypes.HTML && fileType != StdFileTypes.XHTML && fileType != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            return null;
        }
        Project project = psiFile.getProject();
        ApplicationServer server = (ApplicationServer)servers.get(0);
        String url = configurationType.getUrlToOpenInBrowser(server, psiFile);
        if (url == null) {
            return null;
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(psiFile.getName(), configurationType.getLocalFactory());
        CommonStrategy configuration = (CommonStrategy)settings.getConfiguration();
        configuration.setApplicationServer(server);
        configuration.setUrlToOpenInBrowser(url);
        Collection artifacts = ArtifactBySourceFileFinder.getInstance((Project)project).findArtifacts(file);
        DeploymentProvider deploymentProvider = DeploymentManagerEx.getProvider(configuration);
        if (deploymentProvider != null) {
            Artifact toDeploy = null;
            for (Artifact artifact : artifacts) {
                if (!deploymentProvider.getSupportedArtifactTypes().contains(artifact.getArtifactType())) continue;
                toDeploy = artifact;
                break;
            }
            if (toDeploy == null) {
                return null;
            }
            configuration.getDeploymentSettings().getOrCreateModel(toDeploy);
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)configuration, toDeploy);
        }
        return settings;
    }

    public ConfigurationFactory createFactory(J2EEConfigurationType type, boolean isLocal, String name) {
        return new MyConfigurationFactory(type, isLocal, name);
    }

    public boolean isConfigurationApplicable(@NotNull J2EEConfigurationType type, @NotNull Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "isConfigurationApplicable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl", "isConfigurationApplicable"));
        }
        AppServerIntegration integration = type.getIntegration();
        return integration == null || !ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration}).isEmpty();
    }

    private static class CommonStrategyWithoutDefaultDebug
    extends CommonStrategy
    implements RunConfigurationWithSuppressedDefaultDebugAction {
        public CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, ExecutableObjectStartupPolicy executablePolicy) {
            super(name, integration, project, factory, serverModel, isLocal, executablePolicy);
        }

        public CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy) {
            super(name, integration, project, factory, serverModel, isLocal, javaPolicy);
        }
    }

    private static class MyConfigurationFactory
    extends ConfigurationFactoryEx {
        private final boolean myIsLocal;
        private final String myName;
        private J2EEConfigurationType myType;

        public MyConfigurationFactory(J2EEConfigurationType type, boolean isLocal, String name) {
            super((ConfigurationType)type);
            this.myIsLocal = isLocal;
            this.myName = name;
            this.myType = type;
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            RunConfiguration configuration = super.createConfiguration(name, template);
            ((CommonModel)configuration).initialize();
            return configuration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory", "isApplicable"));
            }
            return J2EEConfigurationFactory.getInstance().isConfigurationApplicable(this.myType, project);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return this.myType.createJ2EEConfigurationTemplate((ConfigurationFactory)this, project, this.myIsLocal);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            ServerModel serverModel;
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory", "onNewConfigurationCreated"));
            }
            CommonStrategy model = (CommonStrategy)configuration;
            if (model.getApplicationServer() == null) {
                List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{model.getIntegration()});
                model.setApplicationServer((ApplicationServer)ContainerUtil.getFirstItem((Collection)servers, null));
            }
            if ((serverModel = model.getServerModel()) instanceof ServerModelEx) {
                ((ServerModelEx)serverModel).onNewConfigurationCreated();
            }
        }

        public void onConfigurationCopied(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory", "onConfigurationCopied"));
            }
            ServerModel model = ((CommonModel)configuration).getServerModel();
            if (model instanceof ServerModelEx) {
                ((ServerModelEx)model).onConfigurationCopied();
            }
        }

        public Icon getIcon() {
            return this.myIsLocal ? this.myType.getLocalIcon() : this.myType.getRemoteIcon();
        }

        public String getName() {
            return this.myName;
        }

        public boolean canConfigurationBeSingleton() {
            return false;
        }
    }
}

