/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessConnection;
import com.intellij.javaee.process.JavaeeProcessConnectionException;
import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.JavaeeProcessObjectListener;
import com.intellij.javaee.process.JavaeeProcessRequest;
import com.intellij.javaee.process.JavaeeProcessResponseToRequest;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodParamDeserializer;
import com.intellij.javaee.process.common.MethodResultSerializer;
import com.intellij.javaee.process.common.MethodResultTypeSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.agent.annotation.AsyncCall;
import com.intellij.remoteServer.agent.annotation.FinalCall;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class JavaeeProcessObjectBase<T extends JavaeeProcessObject>
implements JavaeeProcessObject {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaeeProcessObjectBase.class.getName()));
    private final Class<T> myTargetClass;
    private final JavaeeProcessConnection myConnection;
    private final String myObjectId;
    private final MethodResultSerializer myMethodParamSerializer;
    private final MethodParamDeserializer myMethodResultDeserializer;
    private final T myProxy;

    public JavaeeProcessObjectBase(Class<T> targetClass, JavaeeProcessConnection connection, String objectId) {
        this.myTargetClass = targetClass;
        this.myConnection = connection;
        this.myObjectId = objectId;
        this.myMethodParamSerializer = new MethodResultSerializer();
        this.myMethodResultDeserializer = new MethodParamDeserializer();
        this.myProxy = (JavaeeProcessObject)targetClass.cast(Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (InvocationHandler)new InvocationHandlerImpl()));
    }

    protected JavaeeProcessConnection getConnection() {
        return this.myConnection;
    }

    protected MethodResultSerializer getMethodParamSerializer() {
        return this.myMethodParamSerializer;
    }

    protected MethodParamDeserializer getMethodResultDeserializer() {
        return this.myMethodResultDeserializer;
    }

    protected final T getProxy() {
        return this.myProxy;
    }

    protected class MethodListenerParamSerializer<T extends JavaeeProcessObjectListener>
    extends MethodResultTypeSerializer<T> {
        public MethodListenerParamSerializer(Class<T> listenerClass) {
            super(listenerClass);
        }

        @Override
        protected String doSerializeResult(T paramValue) throws JavaeeProcessUtilException {
            int listenerId = JavaeeProcessObjectBase.this.getConnection().getListenerRegistry().registerListener((JavaeeProcessObjectListener)paramValue);
            return String.valueOf(listenerId);
        }
    }

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private InvocationHandlerImpl() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if (JavaeeProcessObjectBase.this.myConnection.isClosed()) {
                return null;
            }
            try {
                JavaeeProcessResponseToRequest response;
                boolean ignoreProtocolException;
                JavaeeProcessRequest request = new JavaeeProcessRequest(JavaeeProcessObjectBase.this.myTargetClass, JavaeeProcessObjectBase.this.myObjectId, method.getName(), JavaeeProcessObjectBase.this.myMethodParamSerializer.serializeArgs(args));
                boolean asyncCall = method.getAnnotation(AsyncCall.class) != null;
                boolean bl = ignoreProtocolException = method.getAnnotation(FinalCall.class) != null;
                if (asyncCall) {
                    JavaeeProcessObjectBase.this.myConnection.requestAsynchronously(request);
                    return null;
                }
                try {
                    response = JavaeeProcessObjectBase.this.myConnection.requestAndWaitForResponse(request);
                }
                catch (JavaeeProcessConnectionException e) {
                    if (ignoreProtocolException) {
                        LOG.debug((Throwable)e);
                    } else {
                        LOG.info((Throwable)e);
                    }
                    return null;
                }
                response.rethrowException();
                return response.isResultNull() ? null : JavaeeProcessObjectBase.this.myMethodResultDeserializer.deserialize(method.getReturnType(), response.getResult());
            }
            catch (JavaeeProcessUtilException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
    }
}

