/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.agent.AgentExtension;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.OutputStream;
import org.jetbrains.annotations.Nullable;

public class ServerTaskRunner
extends JavaeeServerInstanceImpl {
    private static final Logger LOG = Logger.getInstance((String)("#" + ServerTaskRunner.class.getName()));
    private final ProcessHandler myFakeProcessHandler;
    private final ProgressIndicator myIndicator;

    public static ServerTaskRunner create(CommonModel commonModel) throws ExecutionException {
        return ServerTaskRunner.create(commonModel, null);
    }

    public static ServerTaskRunner create(CommonModel commonModel, @Nullable ProgressIndicator indicator) throws ExecutionException {
        DeploymentStatusManager deploymentStatusManager = new DeploymentStatusManager();
        ServerTaskRunner instance = new ServerTaskRunner(commonModel, deploymentStatusManager, indicator);
        instance.prepare();
        deploymentStatusManager.setServerInstance(instance);
        return instance;
    }

    private ServerTaskRunner(CommonModel commonModel, DeploymentStatusManager deploymentStatusManager, ProgressIndicator indicator) throws ExecutionException {
        super(commonModel, deploymentStatusManager);
        this.myIndicator = indicator;
        this.myFakeProcessHandler = new ProcessHandler(){

            protected void destroyProcessImpl() {
            }

            protected void detachProcessImpl() {
            }

            public boolean detachIsDefault() {
                return false;
            }

            public OutputStream getProcessInput() {
                return null;
            }
        };
    }

    public boolean runTask(Runnable task) {
        boolean result;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            result = false;
        }
        if (result) {
            task.run();
            this.disconnect();
        }
        return result;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myFakeProcessHandler;
    }

    @Override
    protected void fireUpdateDeploymentStatus() {
    }

    public AgentExtension getAgentExtension() {
        JavaeeServerExtension serverExtension = this.getExtension();
        LOG.assertTrue(serverExtension != null);
        return serverExtension.getAgentExtension();
    }

    @Override
    protected Notification createConnectErrorNotification(String message) {
        return NotificationGroup.balloonGroup((String)"JavaEE").createNotification(JavaeeBundle.getText("ServerTaskRunner.no.connection", message), NotificationType.ERROR);
    }

    @Override
    protected void handleMessage(String message) {
        if (this.myIndicator != null) {
            this.myIndicator.setText(message);
        }
    }
}

