/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ButtonGroupControl
extends BaseModifiableControl<JComponent, String> {
    private final JComponent parent;
    private final ButtonGroup group;

    public ButtonGroupControl(DomWrapper<String> wrapper, AbstractButton ... buttons) {
        super(wrapper);
        this.parent = (JComponent)buttons[0].getParent();
        this.group = new ButtonGroup();
        for (AbstractButton button : buttons) {
            this.group.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonGroupControl.this.setModified();
                    ButtonGroupControl.this.commit();
                }
            });
        }
    }

    protected JComponent createMainComponent(JComponent component) {
        return component != null ? component : this.parent;
    }

    @Nullable
    protected String getValue() {
        return this.parent.isEnabled() ? this.group.getSelection().getActionCommand() : null;
    }

    protected void setValue(@Nullable String value) {
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            ButtonModel model = e.nextElement().getModel();
            String cmd = model.getActionCommand();
            this.group.setSelected(model, value == null ? cmd == null || cmd.length() == 0 : value.equals(cmd));
        }
    }
}

