/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectorCommand<T> {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractConnectorCommand.class.getName()));
    @NonNls
    private static final String JMX_CONNECTOR_URL = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(ConcurrencyUtil.newNamedThreadFactory((String)"javaee connector"));

    @Nullable
    public final T execute() throws TimeoutException, ExecutionException {
        Callable deployOperation = new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                JMXConnector connector = null;
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    connector = AbstractConnectorCommand.this.getJmxConnector();
                    Object t = AbstractConnectorCommand.this.doExecute(connector.getMBeanServerConnection());
                    return t;
                }
                catch (JMRuntimeException e) {
                    AbstractConnectorCommand.this.logException(e);
                    Object t = null;
                    return t;
                }
                catch (JMException e) {
                    AbstractConnectorCommand.this.logException(e);
                    Object t = null;
                    return t;
                }
                catch (IOException e) {
                    AbstractConnectorCommand.this.logException(e);
                    Object t = null;
                    return t;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    if (connector != null) {
                        try {
                            connector.close();
                        }
                        catch (IOException e) {
                            AbstractConnectorCommand.this.logException(e);
                        }
                    }
                }
            }
        };
        Future task = EXECUTOR.submit(deployOperation);
        try {
            Integer timeoutSeconds = this.getTimeoutSeconds();
            return timeoutSeconds == null ? task.get() : task.get(timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logException(e);
            return null;
        }
    }

    @Nullable
    protected Integer getTimeoutSeconds() {
        return 10;
    }

    private void logException(Exception e) {
        LOG.debug((Throwable)e);
        ILogger logger = this.getLogger();
        if (logger != null) {
            logger.debugEx(e);
        }
    }

    protected ILogger getLogger() {
        return null;
    }

    private JMXConnector getJmxConnector() throws IOException {
        HashMap environment = new HashMap();
        return JMXConnectorFactory.connect(new JMXServiceURL(this.getJmxUrl()), environment);
    }

    protected String getJmxUrl() {
        return String.format(JMX_CONNECTOR_URL, this.getHost(), this.getJmxPort());
    }

    public static <R> R invokeOperation(MBeanServerConnection connection, ObjectName objectName, @NonNls String operationName, Object ... operationArguments) throws JMException, IOException {
        String[] classNames;
        if (operationArguments.length == 0) {
            operationArguments = null;
            classNames = null;
        } else {
            classNames = new String[operationArguments.length];
            for (int i = 0; i < operationArguments.length; ++i) {
                classNames[i] = operationArguments[i] instanceof Boolean ? Boolean.TYPE.getName() : operationArguments[i].getClass().getName();
            }
        }
        return (R)connection.invoke(objectName, operationName, operationArguments, classNames);
    }

    public static Object getAttribute(MBeanServerConnection connection, ObjectName objectName, @NonNls String attributeName) throws JMException, IOException {
        return connection.getAttribute(objectName, attributeName);
    }

    public static ObjectName createObjectName(@NonNls String name) throws MalformedObjectNameException {
        return new ObjectName(name);
    }

    @Nullable
    protected abstract T doExecute(MBeanServerConnection var1) throws JMException, IOException;

    @NonNls
    protected abstract String getHost();

    protected abstract int getJmxPort();

    /*
     * WARNING - void declaration
     */
    public static void awaitQuiescence(long timeout, @NotNull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/javaee/oss/util/AbstractConnectorCommand", "awaitQuiescence"));
        }
        ConcurrencyUtil.awaitQuiescence((ThreadPoolExecutor)((ThreadPoolExecutor)EXECUTOR), (long)timeout, (TimeUnit)unit);
    }
}

