/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.oss.server.JavaeeInstallationDescriptor;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.util.CachedConfig;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeInstallationConfig<D>
extends CachedConfig<JavaeePersistentData> {
    private static final Map<CachedConfig.Key, JavaeeInstallationConfig<?>> ourCache = new HashMap();
    private JavaeeInstallationDescriptor<D> myInstallationDescriptor;
    private Exception myLatestException = null;

    protected static <M extends JavaeePersistentData, D> D get(Factory<M> factory, M model) throws Exception {
        JavaeeInstallationConfig<?> config = JavaeeInstallationConfig.get(ourCache, factory, model);
        if (config != null) {
            if (config.myLatestException != null) {
                throw config.myLatestException;
            }
            return config.myInstallationDescriptor.getData();
        }
        throw new Exception("Server home is not specified");
    }

    @Override
    protected void update(JavaeePersistentData data) {
        try {
            this.myInstallationDescriptor = this.getInstallationDescriptor(data.HOME);
            this.myLatestException = null;
        }
        catch (Exception e) {
            this.myInstallationDescriptor = null;
            this.myLatestException = e;
        }
    }

    @Override
    protected void check(JavaeePersistentData data) {
        if (this.getStamp(data) == 0L) {
            this.update(data);
        }
        super.check(data);
    }

    @Override
    protected long getStamp(JavaeePersistentData data) {
        return JavaeeInstallationConfig.getStamp(this.myInstallationDescriptor != null ? this.myInstallationDescriptor.getStampFile() : null);
    }

    protected abstract JavaeeInstallationDescriptor<D> getInstallationDescriptor(String var1) throws Exception;

    protected static abstract class Factory<T extends JavaeePersistentData>
    implements CachedConfig.Factory<T, JavaeeInstallationConfig<?>> {
        protected Factory() {
        }

        @Override
        @NotNull
        public CachedConfig.Key createKey(JavaeePersistentData data) {
            CachedConfig.Key key = new CachedConfig.Key(data.HOME);
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeInstallationConfig$Factory", "createKey"));
            }
            return key;
        }
    }
}

