/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultTemplateMatcher {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("([\\w-]+)_(\\d)_(\\d)\\.xml");

    @Nullable
    @NonNls
    public static String getNameFromTemplate(String template) throws Exception {
        return new DefaultTemplateMatcher(){

            @Override
            protected String doGetMatch(Matcher matcher) {
                return matcher.group(1);
            }
        }.getMatch(template);
    }

    @Nullable
    @NonNls
    public static String getVersionFromTemplate(String template) throws Exception {
        return new DefaultTemplateMatcher(){

            @Override
            protected String doGetMatch(Matcher matcher) {
                return matcher.group(2) + "." + matcher.group(3);
            }
        }.getMatch(template);
    }

    private DefaultTemplateMatcher() {
    }

    @Nullable
    public String getMatch(String template) {
        Matcher matcher = TEMPLATE_PATTERN.matcher(template);
        return matcher.matches() ? this.doGetMatch(matcher) : null;
    }

    protected abstract String doGetMatch(Matcher var1);
}

