/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.process;

import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.ParametersMapImpl;
import com.intellij.javaee.oss.agent.VendorSpecificAgent;
import com.intellij.javaee.oss.process.AgentCallbackProxy;
import com.intellij.javaee.oss.process.AgentDeploymentCallbackProxy;
import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.common.DocumentReader;
import com.intellij.javaee.process.common.DocumentWriter;
import com.intellij.javaee.process.common.EncodingUtil;
import com.intellij.javaee.process.common.InputReader;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodInvocator;
import com.intellij.javaee.process.common.MethodParamDeserializer;
import com.intellij.javaee.process.common.MethodParamTypeDeserializer;
import com.intellij.javaee.process.common.MethodResultSerializer;
import com.intellij.javaee.process.common.MethodResultTypeSerializer;
import com.intellij.javaee.process.common.OutputWriter;
import com.intellij.javaee.process.server.ResponseDocumentWrapper;
import com.intellij.javaee.process.server.TargetObjectRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaeeProcess {
    public static final String NON_RESPONSE_EXCEPTION_PREFIX = "<Non-response-exception>";
    private final TargetObjectRegistry myTargetObjectRegistry = new TargetObjectRegistry();
    private final VendorSpecificAgent myAgent;

    private JavaeeProcess(VendorSpecificAgent agent) {
        this.myAgent = agent;
    }

    public static void main(String[] args) {
        try {
            VendorSpecificAgent agent = (VendorSpecificAgent)Class.forName(args[1]).getConstructor(new Class[0]).newInstance(new Object[0]);
            new JavaeeProcess(agent).run(Integer.parseInt(args[0]));
        }
        catch (Throwable t) {
            JavaeeProcess.handleNonResponseException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(int port) throws Throwable {
        Socket socket = new Socket("localhost", port);
        try {
            InputReader inputReader = new InputReader(socket.getInputStream());
            try {
                OutputWriter outputWriter = new OutputWriter(socket.getOutputStream());
                try {
                    InputSource inputSource;
                    while ((inputSource = inputReader.getNextSource()) != null) {
                        this.processRequest(inputSource, outputWriter);
                    }
                }
                finally {
                    outputWriter.close();
                }
            }
            finally {
                inputReader.close();
            }
        }
        catch (Throwable t) {
            this.myAgent.destroy();
            throw t;
        }
        finally {
            socket.close();
        }
    }

    private static Class<?> getTargetClass(String targetClassName, ResponseDocumentWrapper responseWrapper) {
        try {
            Class<?> result = Class.forName(targetClassName);
            Class<?>[] targetClassInterfaces = result.getInterfaces();
            if (!result.isInterface() || !Arrays.asList(targetClassInterfaces).contains(JavaeeProcessObject.class)) {
                JavaeeProcess.handleResponseException("Unexpected target class: " + targetClassName, responseWrapper);
                return null;
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            JavaeeProcess.handleResponseException(JavaeeProcess.getExceptionText(e), responseWrapper);
            return null;
        }
    }

    private void processRequest(InputSource inputSource, OutputWriter outputWriter) {
        try {
            JavaeeProcessObject objectWrapper;
            DocumentReader requestReader = new DocumentReader(inputSource, "request");
            String targetClassName = requestReader.getTopElement("targetClassName");
            Document responseDocument = OutputWriter.createDocument();
            ResponseDocumentWrapper responseWrapper = new ResponseDocumentWrapper(responseDocument);
            responseWrapper.setCause("request");
            responseWrapper.createTopElement("requestId", requestReader.getTopElement("requestId"));
            if (VendorSpecificAgent.class.getName().equals(targetClassName)) {
                objectWrapper = this.myAgent;
            } else {
                String targetObjectId = requestReader.getTopElement("targetObjectId");
                objectWrapper = this.myTargetObjectRegistry.getObject(Integer.parseInt(targetObjectId));
            }
            Class<?> targetClass = JavaeeProcess.getTargetClass(targetClassName, responseWrapper);
            if (targetClass != null) {
                String targetMethodName = requestReader.getTopElement("targetMethodName");
                Object resultObject = MethodInvocator.invoke(targetClass, objectWrapper, targetMethodName, requestReader, JavaeeProcess.createMethodParamDeserializer(outputWriter));
                String result = this.createMethodResultSerializer().serialize(resultObject);
                Boolean isResultNull = result == null;
                responseWrapper.createTopElement("result", isResultNull != false ? "" : result);
                responseWrapper.createTopElement("resultIsNull", isResultNull.toString());
            }
            outputWriter.putDocument(responseDocument);
        }
        catch (JavaeeProcessUtilException e) {
            JavaeeProcess.handleNonResponseException(e);
        }
    }

    private static void handleResponseException(String exceptionText, DocumentWriter responseWrapper) {
        responseWrapper.createTopElement("exception", EncodingUtil.encodeBase64(exceptionText));
    }

    public static String getExceptionText(Throwable e) {
        StringWriter exceptionWriter = new StringWriter();
        exceptionWriter.write("Message:\n");
        exceptionWriter.write(e.getMessage());
        exceptionWriter.write("\nStack trace:\n");
        PrintWriter exceptionPrintWriter = new PrintWriter(exceptionWriter);
        try {
            e.printStackTrace(exceptionPrintWriter);
        }
        finally {
            exceptionPrintWriter.close();
        }
        return exceptionWriter.toString();
    }

    public static void handleNonResponseException(Throwable t) {
        System.err.println(NON_RESPONSE_EXCEPTION_PREFIX + JavaeeProcess.getExceptionText(t).replace('\n', ' '));
    }

    public static MethodParamDeserializer createMethodParamDeserializer(final OutputWriter outputWriter) {
        MethodParamDeserializer result = new MethodParamDeserializer();
        result.addType(new MethodParamTypeDeserializer<AgentCallback>(AgentCallback.class){

            @Override
            public AgentCallback deserializeParamValue(String paramValue) {
                return new AgentCallbackProxy(outputWriter, paramValue);
            }
        });
        result.addType(new MethodParamTypeDeserializer<AgentDeploymentCallback>(AgentDeploymentCallback.class){

            @Override
            public AgentDeploymentCallback deserializeParamValue(String paramValue) {
                return new AgentDeploymentCallbackProxy(outputWriter, paramValue);
            }
        });
        result.addType(new MethodParamTypeDeserializer<ParametersMap>(ParametersMap.class){

            @Override
            public ParametersMap deserializeParamValue(String paramValue) throws JavaeeProcessUtilException {
                return ParametersMapImpl.load(paramValue);
            }
        });
        return result;
    }

    public MethodResultSerializer createMethodResultSerializer() {
        MethodResultSerializer result = new MethodResultSerializer();
        result.addType(new MethodResultTypeSerializer<JavaeeProcessObject>(JavaeeProcessObject.class){

            @Override
            protected String doSerializeResult(JavaeeProcessObject methodResult) {
                return String.valueOf(JavaeeProcess.this.myTargetObjectRegistry.getId(methodResult));
            }
        });
        return result;
    }
}

