/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.converter;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.application.JavaeeModule;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebModuleConverter
extends ResolvingConverter<JavaeeModule> {
    @Nullable
    public JavaeeModule fromString(String value, ConvertContext context) {
        if (value != null) {
            for (JavaeeModule javaeeModule : this.getVariants(context)) {
                if (!value.equals(javaeeModule.getWeb().getWebUri().getValue())) continue;
                return javaeeModule;
            }
        }
        return null;
    }

    @Nullable
    public String toString(JavaeeModule value, ConvertContext context) {
        return value != null ? (String)value.getWeb().getWebUri().getValue() : null;
    }

    @NotNull
    public Collection<? extends JavaeeModule> getVariants(ConvertContext context) {
        JavaeeApplication root;
        ArrayList<JavaeeModule> list = new ArrayList<JavaeeModule>();
        JavaeeApplicationFacet facet = (JavaeeApplicationFacet)JavaeeFacetUtil.getInstance().getJavaeeFacet(context, JavaeeApplicationFacet.ID);
        if (facet != null && (root = facet.getRoot()) != null) {
            for (JavaeeModule module : root.getModules()) {
                if (module.getWeb().getXmlTag() == null) continue;
                list.add(module);
            }
        }
        ArrayList<JavaeeModule> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/converter/WebModuleConverter", "getVariants"));
        }
        return arrayList;
    }
}

