/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.module.view.J2EEAbstractDeleteProvider;
import com.intellij.javaee.module.view.ejb.DeleteEjbClassDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.IncorrectOperationException;

public class EjbClassDeleteProvider
extends J2EEAbstractDeleteProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.ejb.actions.EjbClassDeleteProvider");
    private final PsiClass myClass;

    public EjbClassDeleteProvider(Project project, PsiClass aClass, AbstractTreeBuilder builder) {
        super(project, builder);
        this.myClass = aClass;
    }

    private static PsiClass getSameRoleClass(PsiClass aClass) {
        EjbClassRole role = OldEjbRolesUtil.getEjbRole(aClass);
        if (role == null) {
            return null;
        }
        EnterpriseBean ejb = role.getEnterpriseBean();
        if (!(ejb instanceof EjbWithHome)) {
            return null;
        }
        EjbWithHome elementWithHome = (EjbWithHome)ejb;
        switch (role.getType()) {
            case EJB_CLASS_ROLE_HOME_INTERFACE: {
                return (PsiClass)elementWithHome.getLocalHome().getValue();
            }
            case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                return (PsiClass)elementWithHome.getHome().getValue();
            }
            case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                return (PsiClass)elementWithHome.getRemote().getValue();
            }
            case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                return (PsiClass)elementWithHome.getLocal().getValue();
            }
        }
        return null;
    }

    private static PsiClass getCompanionClass(PsiClass aClass) {
        EjbClassRole role = OldEjbRolesUtil.getEjbRole(aClass);
        if (role == null) {
            return null;
        }
        EnterpriseBean ejb = role.getEnterpriseBean();
        if (!(ejb instanceof EjbWithHome)) {
            return null;
        }
        EjbWithHome elementWithHome = (EjbWithHome)ejb;
        switch (role.getType()) {
            case EJB_CLASS_ROLE_EJB_CLASS: {
                return null;
            }
            case EJB_CLASS_ROLE_HOME_INTERFACE: {
                return (PsiClass)elementWithHome.getRemote().getValue();
            }
            case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                return (PsiClass)elementWithHome.getLocal().getValue();
            }
            case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                return (PsiClass)elementWithHome.getLocalHome().getValue();
            }
            case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                return (PsiClass)elementWithHome.getHome().getValue();
            }
        }
        return null;
    }

    @Override
    public void doDeleteElement(DataContext dataContext) {
        PsiClass companionClass = EjbClassDeleteProvider.getCompanionClass(this.myClass);
        DeleteEjbClassDialog dialog = new DeleteEjbClassDialog(this.myProject, this.myClass, companionClass, this.getText());
        if (!dialog.showAndGet()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> {
                String name = J2EEBundle.message((String)"local.vcs.label.name.deleting.ejb.class", (Object[])new Object[]{this.myClass.getQualifiedName()});
                LocalHistoryAction a = LocalHistory.getInstance().startAction(name);
                try {
                    if (dialog.isDeleteClasses()) {
                        this.myClass.delete();
                        if (companionClass != null) {
                            companionClass.delete();
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    a.finish();
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, J2EEBundle.message((String)"command.name.delete.ejb.class", (Object[])new Object[0]), null);
    }

    private String getText() {
        EjbClassRole role = OldEjbRolesUtil.getEjbRole(this.myClass);
        if (role == null) {
            return null;
        }
        String title = role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE || role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE ? J2EEBundle.message((String)"dialog,title.remove.ejb.remote.interface", (Object[])new Object[0]) : J2EEBundle.message((String)"dialog.title.remove.ejb.local.interface", (Object[])new Object[0]);
        return title;
    }
}

