/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.common;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class InheritedClassBrowseButtonListener
implements ActionListener {
    private final PsiClass myBaseClass;
    private final String myTitle;
    private final Project myProject;

    public InheritedClassBrowseButtonListener(String baseClass, String title, Project project) {
        this.myTitle = title;
        this.myProject = project;
        this.myBaseClass = baseClass == null ? null : JavaPsiFacade.getInstance((Project)this.myProject).findClass(baseClass, GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeClassChooserFactory classChooserFactory = TreeClassChooserFactory.getInstance((Project)this.myProject);
        JTextField textField = (JTextField)((FixedSizeButton)e.getSource()).getAttachedComponent();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(textField.getText(), GlobalSearchScope.allScope((Project)this.myProject));
        TreeClassChooser chooser = classChooserFactory.createInheritanceClassChooser(this.myTitle, GlobalSearchScope.allScope((Project)this.myProject), this.myBaseClass, aClass);
        chooser.showDialog();
        aClass = chooser.getSelected();
        if (aClass != null) {
            textField.setText(aClass.getQualifiedName());
        }
    }
}

