/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.module.view.PrefixNameSuffixPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.Function;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;

public abstract class PrefixSuffixSupport {
    private final JavaeeCodeStyleSettings mySettings;
    private String myPrefix;
    private String myShortName;
    private String mySuffix;

    protected PrefixSuffixSupport(Project project) {
        this.mySettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaeeCodeStyleSettings.class);
    }

    public final String composeFullName(String shortName) {
        return this.getPrefix() + shortName + this.getSuffix();
    }

    public final void setUniqueName(String defaultRawName) {
        this.resetPrefixSuffix();
        this.setFullName(new UniqueNameGenerator(this.getExistingElements(), (Function)ElementPresentationManager.NAMER).generateUniqueName(defaultRawName, this.getPrefix(), this.getSuffix()));
    }

    public final boolean isUnique() {
        return new UniqueNameGenerator(this.getExistingElements(), (Function)ElementPresentationManager.NAMER).isUnique(this.myShortName, this.myPrefix, this.mySuffix);
    }

    public final void setRawName(String shortName) {
        this.resetPrefixSuffix();
        this.myShortName = shortName;
    }

    public final void resetPrefixSuffix() {
        this.resetPrefixSuffix(this.getPrefix(this.mySettings), this.getSuffix(this.mySettings));
    }

    private void resetPrefixSuffix(String prefix, String suffix) {
        this.myPrefix = prefix;
        this.mySuffix = suffix;
    }

    public final void setFullName(String fullName) {
        this.resetPrefixSuffix();
        this.resetPrefixSuffix(fullName.startsWith(this.myPrefix) ? this.myPrefix : "", fullName.endsWith(this.mySuffix) ? this.mySuffix : "");
        this.myShortName = fullName.substring(this.getPrefix().length(), fullName.length() - this.getSuffix().length());
    }

    public final String getRawName() {
        return this.myShortName;
    }

    public final String getIdentifierCompatibleRawName() {
        return PrefixNameSuffixPanel.suggestIdentifierCompatibleName(this.getRawName());
    }

    public final String getFullName() {
        return this.getPrefix() + this.myShortName + this.getSuffix();
    }

    public final String getPrefix() {
        return this.myPrefix;
    }

    public final boolean hasPrefix() {
        return StringUtil.isNotEmpty((String)this.myPrefix);
    }

    public final boolean hasSuffix() {
        return StringUtil.isNotEmpty((String)this.mySuffix);
    }

    public final String getSuffix() {
        return this.mySuffix;
    }

    protected abstract String getPrefix(JavaeeCodeStyleSettings var1);

    protected abstract String getSuffix(JavaeeCodeStyleSettings var1);

    protected abstract Collection getExistingElements();
}

