/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaeeFileEditorProvider<T extends JavaeeDomModelElement, F extends JavaeeFacet>
extends PerspectiveFileEditorProvider {
    private final Class<T> myClass;
    private final FacetTypeId<F> myFacetTypeId;

    protected AbstractJavaeeFileEditorProvider(Class<T> aClass, FacetTypeId<F> facetType) {
        this.myClass = aClass;
        this.myFacetTypeId = facetType;
    }

    @Nullable
    protected abstract T getEditedElement(@NotNull F var1, VirtualFile var2);

    @Nullable
    private T getEditedElement(@NotNull Project project, @NotNull VirtualFile file) {
        Facet facet;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "getEditedElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "getEditedElement"));
        }
        if (!file.isValid()) {
            return null;
        }
        if (file instanceof FacetAsVirtualFile && (facet = ((FacetAsVirtualFile)file).findFacet()) != null && facet.getTypeId().equals(this.myFacetTypeId)) {
            return this.getEditedElement((JavaeeFacet)facet, file);
        }
        facet = JavaeeFacetUtil.getInstance().getJavaeeFacet(file, this.myFacetTypeId, project);
        if (facet == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, this.myClass);
            if (fileElement != null) {
                return (T)((JavaeeDomModelElement)fileElement.getRootElement());
            }
        }
        return null;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "accept"));
        }
        return this.getEditedElement(project, file) != null;
    }

    @NotNull
    protected abstract PerspectiveFileEditor createEditor(@NotNull T var1, @NotNull F var2);

    @NotNull
    public PerspectiveFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "createEditor"));
        }
        PerspectiveFileEditor perspectiveFileEditor = this.createEditor((JavaeeDomModelElement)DomManager.getDomManager((Project)project).createStableValue((Factory)((NullableFactory)() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "lambda$createEditor$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "lambda$createEditor$0"));
            }
            return this.getEditedElement(project, file);
        })), this.getFacet(project, file));
        if (perspectiveFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "createEditor"));
        }
        return perspectiveFileEditor;
    }

    @NotNull
    private F getFacet(Project project, VirtualFile file) {
        if (file instanceof FacetAsVirtualFile) {
            JavaeeFacet javaeeFacet = (JavaeeFacet)ObjectUtils.assertNotNull((Object)((FacetAsVirtualFile)file).findFacet());
            if (javaeeFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "getFacet"));
            }
            return (F)javaeeFacet;
        }
        JavaeeFacet javaeeFacet = (JavaeeFacet)ObjectUtils.assertNotNull((Object)JavaeeFacetUtil.getInstance().getJavaeeFacet(file, this.myFacetTypeId, project));
        if (javaeeFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider", "getFacet"));
        }
        return (F)javaeeFacet;
    }
}

