/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.util.xml.GenericValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeReferenceImpl
extends CommonModelElement.PsiBase
implements JavaeeReference,
JamElement {
    public static final SemKey<JavaeeReferenceImpl> JAVAEE_REFERENCE_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("JAVAEE_REFERENCE_JAM_KEY", new SemKey[0]);
    public static final JamAttributeMeta<JamStringAttributeElement<String>> NAME_META = JamAttributeMeta.singleString((String)"name", (JamConverter)new JamConverter<String>(){

        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            if (s == null) {
                PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)context.getParentAnnotationElement().getRoot(), PsiMember.class, (boolean)false);
                assert (psiMember != null);
                return AnnotationModelUtil.getPsiMemberName(psiMember);
            }
            return s;
        }
    });
    public static final JamAttributeMeta<JamStringAttributeElement<String>> MAPPED_NAME_META = JamAttributeMeta.singleString((String)"mappedName");
    public static final JamClassAttributeMeta.Single TYPE_META = JamAttributeMeta.singleClass((String)"type");
    public static final JamAnnotationArchetype REFERENCE_ARCHETYPE = new JamAnnotationArchetype().addAttribute(NAME_META).addAttribute(MAPPED_NAME_META).addAttribute((JamAttributeMeta)TYPE_META);
    private final PsiMember myPsiMember;
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public JavaeeReferenceImpl(PsiMember psiMember) {
        this.myPsiMember = psiMember;
        this.myPsiAnnotation = this.createAnnoRef();
    }

    public JavaeeReferenceImpl(PsiAnnotation psiAnnotation) {
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)psiAnnotation);
        this.myPsiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMember.class, (boolean)true);
    }

    protected abstract PsiElementRef<PsiAnnotation> createAnnoRef();

    @NotNull
    public PsiElement getPsiElement() {
        PsiMember psiMember = this.myPsiMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/JavaeeReferenceImpl", "getPsiElement"));
        }
        return psiMember;
    }

    public PsiMember getPsiMember() {
        return this.myPsiMember;
    }

    @NotNull
    public PsiElementRef<PsiAnnotation> getAnnotationRef() {
        PsiElementRef<PsiAnnotation> psiElementRef = this.myPsiAnnotation;
        if (psiElementRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/JavaeeReferenceImpl", "getAnnotationRef"));
        }
        return psiElementRef;
    }

    public GenericValue<String> getName() {
        return (GenericValue)NAME_META.getJam(this.myPsiAnnotation);
    }

    public GenericValue<String> getMappedName() {
        return (GenericValue)MAPPED_NAME_META.getJam(this.myPsiAnnotation);
    }

    public GenericValue<PsiClass> getType() {
        return TYPE_META.getJam(this.myPsiAnnotation, (Factory)((NullableFactory)() -> AnnotationModelUtil.getPsiMemberType(this.getPsiMember())));
    }

    public List<AnnotationGenericValue<PsiMember>> getTargetMembers() {
        return Collections.singletonList(AnnotationGenericValue.getInstance(this.getPsiMember(), (PsiAnnotation)this.myPsiAnnotation.getPsiElement(), null));
    }
}

