/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.make;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2EECompilerManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.make.J2EECompilerManager");
    private final Project myProject;
    private final FrameStateListener myJavaeeCompileRunnable;

    public J2EECompilerManager(final Project project, final CompilerManager compilerManager) {
        this.myProject = project;
        this.myJavaeeCompileRunnable = new FrameStateListener.Adapter(){

            public void onFrameDeactivated() {
                List processes;
                if (!(project.isDisposed() || !project.isInitialized() || compilerManager.isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator() || (processes = J2EECompilerManager.getActiveJavaeeProcesses(J2EECompilerManager.this.myProject)).isEmpty())) {
                    J2EECompilerManager.this.makeJavaeeModules(processes);
                }
            }
        };
    }

    private static List<J2EEProcess> getActiveJavaeeProcesses(@Nullable Project project) {
        ProcessHandler[] processes;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<J2EEProcess> activeProcesses = new ArrayList<J2EEProcess>();
        for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (!(process instanceof J2EEProcess) || process.isProcessTerminated() || process.isProcessTerminating() || !process.isStartNotified()) continue;
            activeProcesses.add((J2EEProcess)process);
        }
        return activeProcesses;
    }

    private void makeJavaeeModules(List<J2EEProcess> processes) {
        try {
            for (J2EEProcess process : processes) {
                CommonStrategy strategy = process.getCommonStrategy();
                UpdatingPolicy policy = strategy.getUpdateOnFrameDeactivationPolicy();
                Executor executor = UpdatingRunningApplicationUtil.getExecutor(process);
                if (policy == null || !policy.isAvailableForConfiguration(strategy) || !policy.isAvailableForExecutor(executor) || !policy.isAvailableOnFrameDeactivation()) continue;
                policy.runUpdate(this.myProject, null, process.getServerInstance(), (ProcessHandler)process, true);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void setValidator(CompilerManager compilerManager, FrameStateManager saveAndSyncHandler) {
        this.registerCompilers(compilerManager, saveAndSyncHandler);
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    public void disposeComponent() {
        this.unregisterCompilers();
    }

    public void unregisterCompilers() {
        FrameStateManager saveAndSyncHandler = FrameStateManager.getInstance();
        if (saveAndSyncHandler != null) {
            saveAndSyncHandler.removeListener(this.myJavaeeCompileRunnable);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("J2EE Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/make/J2EECompilerManager", "getComponentName"));
        }
        return "J2EE Compiler";
    }

    public void initComponent() {
    }

    public void registerCompilers(CompilerManager compilerManager, FrameStateManager saveAndSyncHandler) {
        if (saveAndSyncHandler != null) {
            saveAndSyncHandler.addListener(this.myJavaeeCompileRunnable);
        }
    }
}

