/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.framework;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.ui.packaging.JavaeeFacetClassesPackagingElement;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFrameworkSupportProviderBase<F extends JavaeeFacet>
extends FrameworkSupportInModuleProvider {
    private final ConfigFileMetaData myMetaData;
    private final String myRelativeDescriptorBaseDir;
    private final JavaeeFacetType<F, ?> myFacetType;

    protected JavaeeFrameworkSupportProviderBase(JavaeeFacetType<F, ?> facetType, ConfigFileMetaData metaData, String relativeDescriptorBaseDir) {
        this.myMetaData = metaData;
        this.myRelativeDescriptorBaseDir = relativeDescriptorBaseDir;
        this.myFacetType = facetType;
    }

    protected void setupConfiguration(F facet, ModifiableRootModel rootModel, ConfigFileVersion configFileVersion) {
    }

    private String getDescriptorUrl(ModuleRootModel rootModel) {
        String[] contentRootUrls = rootModel.getContentRootUrls();
        if (contentRootUrls.length == 0) {
            return null;
        }
        return contentRootUrls[0] + this.myRelativeDescriptorBaseDir + "/" + this.myMetaData.getDirectoryPath() + "/" + this.myMetaData.getFileName();
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase", "isSupportAlreadyAdded"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase", "isSupportAlreadyAdded"));
        }
        if (!facetsProvider.getFacetsByType(module, this.myFacetType.getId()).isEmpty()) {
            return true;
        }
        String url = this.getDescriptorUrl((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
        return url != null && VirtualFileManager.getInstance().findFileByUrl(url) != null;
    }

    protected void createFiles(F facet, JavaeeFrameworkSupportInfoCollector collector) {
    }

    protected Artifact createJavaeeArtifact(JavaeeFacet facet) {
        Module module = facet.getModule();
        Project project = module.getProject();
        ArtifactRootElement root = PackagingElementFactory.getInstance().createArtifactRootElement();
        root.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(facet));
        this.addPackagingElements(facet, (CompositePackagingElement<?>)root);
        String artifactName = JavaeeUtil.suggestArtifactName(module.getName(), null, (FacetTypeId<? extends JavaeeFacet>)this.myFacetType.getId());
        return ArtifactManager.getInstance((Project)project).addArtifact(artifactName, this.myFacetType.getExplodedArtifactType(), (CompositePackagingElement)root);
    }

    protected void addPackagingElements(JavaeeFacet facet, CompositePackagingElement<?> root) {
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)facet.getModule().getProject()).getResolvingContext();
        PackagingElement<?> classesElement = JavaeeFacetClassesPackagingElement.createPackagingElementForFacetClasses(facet, context);
        factory.getOrCreateDirectory(root, this.myFacetType.getDefaultUriForDirectory()).addOrFindChild(classesElement);
    }

    protected class JavaeeFrameworkSupportConfigurable
    extends FrameworkSupportInModuleConfigurable {
        protected final FrameworkSupportModel myModel;

        public JavaeeFrameworkSupportConfigurable(FrameworkSupportModel model) {
            this.myModel = model;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase$JavaeeFrameworkSupportConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase$JavaeeFrameworkSupportConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/javaee/framework/JavaeeFrameworkSupportProviderBase$JavaeeFrameworkSupportConfigurable", "addSupport"));
            }
            JavaeeFrameworkVersionBase version = (JavaeeFrameworkVersionBase)((FrameworkSupportModelBase)this.myModel).getSelectedVersion(JavaeeFrameworkSupportProviderBase.this.getFrameworkType().getId());
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            if (!facetManager.getFacetsByType(JavaeeFrameworkSupportProviderBase.this.myFacetType.getId()).isEmpty()) {
                return;
            }
            ModifiableFacetModel model = facetManager.createModifiableModel();
            JavaeeFacet facet = (JavaeeFacet)facetManager.createFacet((FacetType)JavaeeFrameworkSupportProviderBase.this.myFacetType, JavaeeFrameworkSupportProviderBase.this.myFacetType.getDefaultFacetName(), null);
            ConfigFileVersion configFileVersion = version != null ? this.getVersionToCreate(version) : null;
            String descriptorUrl = JavaeeFrameworkSupportProviderBase.this.getDescriptorUrl((ModuleRootModel)rootModel);
            if (configFileVersion != null && descriptorUrl != null) {
                facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(JavaeeFrameworkSupportProviderBase.this.myMetaData, descriptorUrl);
            }
            JavaeeFrameworkSupportProviderBase.this.setupConfiguration(facet, rootModel, configFileVersion);
            model.addFacet((Facet)facet);
            model.commit();
            JavaeeFrameworkSupportInfoCollector collector = JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)this.myModel);
            collector.setFacet(JavaeeFrameworkSupportProviderBase.this.myFacetType.getId(), (Facet)facet);
            collector.setArtifact(JavaeeFrameworkSupportProviderBase.this.myFacetType.getExplodedArtifactType(), JavaeeFrameworkSupportProviderBase.this.createJavaeeArtifact(facet));
            JavaeeFrameworkSupportProviderBase.this.createFiles(facet, collector);
            if (configFileVersion != null && descriptorUrl != null) {
                ConfigFileFactory.getInstance().createFile(null, descriptorUrl, configFileVersion, true);
            }
        }

        @Nullable
        protected ConfigFileVersion getVersionToCreate(JavaeeFrameworkVersionBase frameworkVersion) {
            return frameworkVersion.getDescriptorVersion();
        }

        @Nullable
        public JComponent createComponent() {
            return null;
        }
    }
}

