/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.framework;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFrameworkDetector<F extends JavaeeFacet, C extends JavaeeFacetConfiguration>
extends FacetBasedFrameworkDetector<F, C> {
    protected JavaeeFrameworkDetector(@NotNull String detectorId) {
        if (detectorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectorId", "com/intellij/javaee/framework/JavaeeFrameworkDetector", "<init>"));
        }
        super(detectorId);
    }

    protected void setupConfiguration(C configuration, VirtualFile file) {
    }

    @NotNull
    public abstract JavaeeFacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<VirtualFile> files, @NotNull Collection<C> existentFacetConfigurations) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/javaee/framework/JavaeeFrameworkDetector", "createConfigurations"));
        }
        if (existentFacetConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existentFacetConfigurations", "com/intellij/javaee/framework/JavaeeFrameworkDetector", "createConfigurations"));
        }
        ArrayList<Pair<C, Collection<VirtualFile>>> result = new ArrayList<Pair<C, Collection<VirtualFile>>>();
        FacetType facetType = this.getFacetType();
        block0: for (VirtualFile file : files) {
            ConfigFileMetaData descriptorMetaData = facetType.getMainDescriptorMetaData();
            for (JavaeeFacetConfiguration configuration : existentFacetConfigurations) {
                ConfigFileInfo configFile = configuration.getDescriptorsConfiguration().getConfigFileInfo(descriptorMetaData);
                if (configFile == null || !configFile.getUrl().equals(file.getUrl())) continue;
                continue block0;
            }
            JavaeeFacetConfiguration configuration = (JavaeeFacetConfiguration)facetType.createDefaultConfiguration();
            configuration.getDescriptorsConfiguration().addConfigFile(descriptorMetaData, file.getUrl());
            this.setupConfiguration(configuration, file);
            result.add(Pair.create((Object)configuration, Collections.singletonList(file)));
        }
        ArrayList<Pair<C, Collection<VirtualFile>>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/framework/JavaeeFrameworkDetector", "createConfigurations"));
        }
        return arrayList;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/framework/JavaeeFrameworkDetector", "getFileType"));
        }
        return languageFileType;
    }
}

