/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.migration;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleDialog;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleViewDescriptor;
import com.intellij.javaee.ejb.migration.JavaeeStyleEngine;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ApplyJavaeeStyleProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.migration.ApplyJavaeeStyleProcessor");
    private final ApplyJavaeeStyleDialog myDialog;
    private PsiFile[] filesWithInvalidValues = PsiFile.EMPTY_ARRAY;

    public ApplyJavaeeStyleProcessor(Project project, ApplyJavaeeStyleDialog dialog) {
        super(project);
        this.myDialog = dialog;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "createUsageViewDescriptor"));
        }
        EnterpriseBean[] enterpriseBeans = this.myDialog.getEnterpriseBeans();
        PsiClass[] psiClasses = new PsiClass[enterpriseBeans.length];
        for (int i = 0; i < psiClasses.length; ++i) {
            psiClasses[i] = (PsiClass)enterpriseBeans[i].getEjbClass().getValue();
        }
        ApplyJavaeeStyleViewDescriptor applyJavaeeStyleViewDescriptor = new ApplyJavaeeStyleViewDescriptor(PsiClass.EMPTY_ARRAY);
        if (applyJavaeeStyleViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "createUsageViewDescriptor"));
        }
        return applyJavaeeStyleViewDescriptor;
    }

    protected String getCommandName() {
        return J2EEBundle.message((String)"apply.javaee.style.command", (Object[])new Object[0]);
    }

    public void doRun() {
        super.doRun();
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "preprocessUsages"));
        }
        final MultiMap conflicts = new MultiMap();
        if (this.myDialog != null) {
            ConflictsDialog dialog;
            JavaeeStyleEngine.MyUsageVisitor visitor = new JavaeeStyleEngine.MyUsageVisitor(){

                @Override
                public void visitMyUsageInfo(JavaeeStyleEngine.MyUsageInfo usageInfo) {
                    if (usageInfo instanceof JavaeeStyleEngine.AddElementUsageInfo && usageInfo.getElement() instanceof PsiClass) {
                        ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, (PsiClass)usageInfo.getElement(), ((JavaeeStyleEngine.AddElementUsageInfo)usageInfo).getNewElements());
                    } else if (usageInfo instanceof JavaeeStyleEngine.ReplaceElementUsageInfo) {
                        JavaeeStyleEngine.ReplaceElementUsageInfo replaceInfo = (JavaeeStyleEngine.ReplaceElementUsageInfo)usageInfo;
                        if (usageInfo.getElement() instanceof PsiMember) {
                            ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, ((PsiMember)usageInfo.getElement()).getContainingClass(), Collections.singletonList(replaceInfo.getNewElement()));
                        } else if (usageInfo.getElement() instanceof PsiIdentifier && usageInfo.getElement().getParent() instanceof PsiMember) {
                            PsiMember psiMember = (PsiMember)usageInfo.getElement().getParent();
                            PsiElement newName = replaceInfo.getNewElement();
                            PsiMember psiCopy = (PsiMember)psiMember.copy();
                            try {
                                if (psiCopy instanceof PsiField) {
                                    ((PsiField)psiCopy).getNameIdentifier().replace(newName);
                                } else {
                                    ((PsiMethod)psiCopy).getNameIdentifier().replace(newName);
                                }
                                ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, psiMember.getContainingClass(), Collections.singletonList(psiCopy));
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            if (refUsages.get() == null) {
                return false;
            }
            for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                assert (usageInfo instanceof JavaeeStyleEngine.MyUsageInfo);
                ((JavaeeStyleEngine.MyUsageInfo)usageInfo).accept(visitor);
            }
            if (conflicts.size() > 0 && !(dialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])refUsages.get())).showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    private void checkExistingMembers(MultiMap<PsiElement, String> conflicts, PsiClass psiClass, List<? extends PsiElement> elements) {
        for (PsiElement psiElement : elements) {
            PsiMethod psiMethod;
            String message;
            String descr;
            PsiField psiMember;
            if (psiElement instanceof PsiField) {
                PsiField psiField = (PsiField)psiElement;
                psiMember = psiClass.findFieldByName(psiField.getName(), false);
                if (psiMember == null) continue;
                descr = PsiFormatUtil.formatVariable((PsiVariable)psiMember, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                message = J2EEBundle.message((String)"apply.javaee.style.field.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr)});
                conflicts.putValue((Object)psiMember, (Object)message);
                continue;
            }
            if (!(psiElement instanceof PsiMethod) || (psiMember = psiClass.findMethodBySignature(psiMethod = (PsiMethod)psiElement, false)) == null) continue;
            descr = PsiFormatUtil.formatMethod((PsiMethod)psiMember, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            message = J2EEBundle.message((String)"apply.javaee.style.method.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr)});
            conflicts.putValue((Object)psiMember, (Object)message);
        }
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfos;
        block3: {
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                JavaeeStyleEngine migrator = new JavaeeStyleEngine(this.myDialog);
                usageInfos = migrator.calculateUsages();
                this.filesWithInvalidValues = migrator.getFileWithInvalidValues();
                if (usageInfos != null) break block3;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                if (UsageInfo.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "findUsages"));
                }
                return UsageInfo.EMPTY_ARRAY;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "findUsages"));
        }
        return usageInfos;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "refreshElements"));
        }
        this.myDialog.refreshEnterpriseBeans();
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor", "performRefactoring"));
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myDialog.getModule().getProject());
        try {
            for (UsageInfo usage : JavaeeStyleEngine.preprocessUsages(usages)) {
                assert (usage instanceof JavaeeStyleEngine.MyUsageInfo);
                JavaeeStyleEngine.MyUsageInfo myUsage = (JavaeeStyleEngine.MyUsageInfo)usage;
                for (PsiElement psiElement : myUsage.processUsage()) {
                    codeStyleManager.shortenClassReferences(psiElement);
                }
            }
            JavaeeStyleEngine.postProcess(this.myDialog);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        PsiFile[] psiFiles = this.filesWithInvalidValues;
        this.filesWithInvalidValues = PsiFile.EMPTY_ARRAY;
        JavaeeStyleEngine.processInvalidValues(psiFiles);
    }
}

