/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbProhibitedPackageUsageInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.prohibited.package.usage", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbProhibitedPackageUsageInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection", "getShortName"));
        }
        return "EjbProhibitedPackageUsageInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiClass psiClass = PsiUtil.getTopLevelClass((PsiElement)reference);
                if (psiClass != null && EjbProhibitedPackageUsageInspection.this.acceptClass(psiClass)) {
                    EjbProhibitedPackageUsageInspection.checkReferenceElement(holder, reference);
                }
            }
        };
    }

    private static void checkReferenceElement(ProblemsHolder holder, PsiJavaCodeReferenceElement element) {
        String qualifiedName;
        PsiElement resolved;
        if (element.getText() != null && (resolved = element.resolve()) instanceof PsiClass && (qualifiedName = ((PsiClass)resolved).getQualifiedName()) != null && Pattern.matches("^(java\\.io\\.File|java\\.awt|javax\\.swing|java\\.lang\\.reflect|java\\.security\\.Policy|java\\.security\\.Security|java\\.security\\.Provider|java\\.security\\.Signer|java\\.security\\.Identity|java\\.net\\.ServerSocket|java\\.lang\\.ClassLoader|java\\.lang\\.SecurityManager|java\\.lang\\.Thread).*$", qualifiedName)) {
            holder.registerProblem((PsiElement)element, EjbHighlightingMessages.message("prohibited.package.usage", qualifiedName), new LocalQuickFix[0]);
        }
    }
}

