/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import java.util.EnumSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterfaceSignatureInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interface.signature", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterfaceSignatureInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection", "getShortName"));
        }
        return "EjbInterfaceSignatureInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(aClass);
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                for (EjbClassRoleEnum type : roleTypes) {
                    if (!type.isInterface()) continue;
                    EjbInterfaceSignatureInspection.checkClassSignature(holder, aClass, classRoles, roleTypes);
                    return;
                }
            }
        };
    }

    private static void checkClassSignature(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        EjbHighlightUtil.checkClassIsInterface(holder, aClass, true);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "public", true);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "final", false);
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalObject", false);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBObject", false);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "java.rmi.Remote", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBHome", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalHome", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalObject", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBObject", true);
        }
    }
}

