/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbEntityInterfaceInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.entity.interface", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbEntityInterfaceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection", "getShortName"));
        }
        return "EjbEntityInterfaceInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (!EjbEntityInterfaceInspection.isOfType(EntityBean.class, classRoles)) {
            return false;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbEntityInterfaceInspection.getRoleTypes(classRoles);
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(method.getContainingClass());
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE)) {
                    block3: for (EjbMethodRole role : methodRoles) {
                        switch (role.getType()) {
                            case EJB_METHOD_ROLE_CMR_GETTER_DECL: 
                            case EJB_METHOD_ROLE_CMR_SETTER_DECL: {
                                EjbHighlightUtil.checkCmrAccessorSignature(holder, method, role);
                                break block3;
                            }
                            default: {
                                continue block3;
                            }
                        }
                    }
                }
            }
        };
    }
}

