/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.inspections.EjbSessionHomeInterfaceInspection;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbEntityHomeInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.entity.home.interface", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbEntityHomeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection", "getShortName"));
        }
        return "EjbEntityHomeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (!EjbEntityHomeInspection.isOfType(EntityBean.class, classRoles)) {
            return false;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbEntityHomeInspection.getRoleTypes(classRoles);
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbEntityHomeInspection.checkExistsFindByPKMethod(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }

            public void visitMethod(PsiMethod method) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(method.getContainingClass());
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                EjbEntityHomeInspection.checkCreateMethod(holder, method, methodRoles);
                EjbEntityHomeInspection.checkFinderMethod(holder, method, methodRoles);
                EjbEntityHomeInspection.checkCreateMethodReturn(holder, method, methodRoles, roleTypes);
                EjbEntityHomeInspection.checkFinderMethodReturn(holder, method, methodRoles, roleTypes);
            }
        };
    }

    private static void checkFinderMethodReturn(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        boolean checkReturn = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) continue;
            checkReturn = true;
            break;
        }
        if (!checkReturn) {
            return;
        }
        boolean findByPK = method.getName().equals("findByPrimaryKey");
        boolean collection = EjbUtil.isCollectionFinderMethod(method);
        HashSet<String> interfaces = EjbEntityHomeInspection.getRequiredInterfaces(methodRoles, EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL, roleTypes);
        if (interfaces.size() > 1) {
            if (!collection) {
                if (!findByPK) {
                    interfaces.add("java.util.Collection");
                    interfaces.add("java.util.Enumeration");
                }
                holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingMessages.message("method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(interfaces.toArray())), new LocalQuickFix[0]);
            }
        } else if (interfaces.size() == 1) {
            if (findByPK) {
                EjbHighlightUtil.checkMethodReturns(holder, method, interfaces.iterator().next());
            } else {
                EjbHighlightUtil.checkMethodReturns(holder, method, new Object[]{"java.util.Collection", "java.util.Enumeration", interfaces.iterator().next()});
            }
        }
    }

    private static void checkCreateMethodReturn(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        EjbSessionHomeInterfaceInspection.checkCreateMethodReturn(holder, method, methodRoles, roleTypes);
    }

    private static HashSet<String> getRequiredInterfaces(EjbMethodRole[] methodRoles, EjbMethodRoleEnum roleType, EnumSet<EjbClassRoleEnum> roleTypes) {
        return EjbSessionHomeInterfaceInspection.getRequiredInterfaces(methodRoles, roleType, roleTypes);
    }

    private static void checkFinderMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkFinderException = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) continue;
            checkFinderException = true;
        }
        if (checkFinderException) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.FinderException", true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkExistsFindByPKMethod(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        block9: {
            PsiMethod[] psiFindByPK;
            EjbClassRole chosenClassRole;
            block7: {
                PsiMethod method;
                HashSet<PsiClassType> pkClasses;
                block8: {
                    chosenClassRole = null;
                    for (EjbClassRole ejbClassRole : classRoles) {
                        EntityBean ejb;
                        if (!(ejbClassRole.getEnterpriseBean() instanceof EntityBean) || aClass != (ejb = (EntityBean)ejbClassRole.getEnterpriseBean()).getHome().getValue() && aClass != ejb.getLocalHome().getValue()) continue;
                        chosenClassRole = ejbClassRole;
                        break;
                    }
                    if (chosenClassRole == null) {
                        return;
                    }
                    psiFindByPK = aClass.findMethodsByName("findByPrimaryKey", true);
                    if (psiFindByPK.length != 1) break block7;
                    pkClasses = new HashSet<PsiClassType>();
                    method = psiFindByPK[0];
                    for (EjbMethodRole role : OldEjbRolesUtil.getEjbRoles(method)) {
                        EntityBean ejb;
                        PsiClass pkClass;
                        if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL || (pkClass = (PsiClass)(ejb = (EntityBean)role.getEnterpriseBean()).getPrimKeyClass().getValue()) == null) continue;
                        pkClasses.add(JavaPsiFacade.getInstance((Project)pkClass.getProject()).getElementFactory().createType(pkClass));
                    }
                    if (pkClasses.size() <= 1) break block8;
                    holder.registerProblem((PsiElement)method.getParameterList(), EjbHighlightingMessages.message("method.parameter.of.type.expected", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(pkClasses.toArray())), new LocalQuickFix[0]);
                    break block9;
                }
                if (pkClasses.size() != 1) break block9;
                EjbHighlightUtil.checkMethodParameters(holder, method, new PsiType[]{(PsiType)pkClasses.iterator().next()});
                break block9;
            }
            if (psiFindByPK.length == 0) {
                EntityBean ejb = (EntityBean)chosenClassRole.getEnterpriseBean();
                boolean isRemote = aClass == ejb.getHome().getValue();
                PsiClass psiClass = isRemote ? (PsiClass)ejb.getRemote().getValue() : (PsiClass)ejb.getLocal().getValue();
                PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
                if (psiClass == null || pkClass == null) {
                    return;
                }
                String[] exceptions = isRemote ? new String[]{"javax.ejb.FinderException", "java.rmi.RemoteException"} : new String[]{"javax.ejb.FinderException"};
                holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message("home.interface.should.define.findbyprimarykey.method", aClass.getName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createAddMethodFix(EjbEntityHomeInspection.finderMethodTemplate(psiClass, pkClass), aClass, exceptions)});
            } else {
                void var7_15;
                PsiMethod[] psiMethodArray = psiFindByPK;
                int n = psiMethodArray.length;
                boolean bl = false;
                while (var7_15 < n) {
                    PsiMethod psiMethod = psiMethodArray[var7_15];
                    holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), EjbHighlightingMessages.message("home.interface.should.define.findbyprimarykey.method", aClass.getName()), new LocalQuickFix[0]);
                    ++var7_15;
                }
            }
        }
    }

    private static String finderMethodTemplate(PsiClass ejbInterface, PsiClass pkClass) {
        return "public " + ejbInterface.getQualifiedName() + " findByPrimaryKey(" + pkClass.getQualifiedName() + " key);";
    }

    private static void checkCreateMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkCreateException = false;
        boolean checkCMP1Create = false;
        for (EjbMethodRole methodRole : methodRoles) {
            if (methodRole.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) continue;
            checkCreateException = true;
            EnterpriseBean ejb = methodRole.getEnterpriseBean();
            if (!(ejb instanceof EntityBean) || !EjbUtil.isCMP(ejb, CmpVersion.CmpVersion_1_X)) continue;
            checkCMP1Create = true;
        }
        if (checkCreateException) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.CreateException", true);
        }
        if (checkCMP1Create && method.getName().length() > "create".length()) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("cmp1.entity.beans.not.authorized.to.define.method", method.getName()), new LocalQuickFix[0]);
        }
    }
}

