/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.model.enums.TransactionType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbClassBasicInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.ejb.class", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbClassBasicInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbClassBasicInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbClassBasicInspection", "getShortName"));
        }
        return "EjbClassBasicInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbClassBasicInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        return EjbClassBasicInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass)).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbClassBasicInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbClassBasicInspection.checkClass(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }

            public void visitMethod(PsiMethod method) {
                EjbClassBasicInspection.checkMethod(holder, method, OldEjbRolesUtil.getEjbRoles(method), OldEjbRolesUtil.getEjbRoles(method.getContainingClass()));
            }

            public void visitField(PsiField field) {
            }
        };
    }

    public static void checkMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EjbClassRole[] classRoles) {
        EjbClassBasicInspection.checkEJBMethodNotStatic(holder, method, methodRoles);
        EjbClassBasicInspection.checkBusinessMethodNotFinal(holder, method, methodRoles);
        EjbClassBasicInspection.checkCreateMethod(holder, method, methodRoles);
        EjbClassBasicInspection.checkFinalizeNotExists(holder, method);
        for (EjbClassRole role : classRoles) {
            if (role.getEnterpriseBean() != null && !EjbUtil.isEjbVersion1x((JavaeeModelElement)role.getEnterpriseBean()) && EjbClassBasicInspection.checkThrowsRemoteException(holder, method, role)) break;
        }
    }

    private static void checkEJBMethodNotStatic(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRole) {
        if (methodRole == null) {
            return;
        }
        EjbHighlightUtil.checkMethodModifier(holder, method, "static", false);
    }

    private static void checkBusinessMethodNotFinal(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        for (EjbMethodRole methodRole : methodRoles) {
            if (methodRole.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL) continue;
            EjbHighlightUtil.checkMethodModifier(holder, method, "final", false);
            break;
        }
    }

    static boolean checkThrowsRemoteException(ProblemsHolder holder, PsiMethod method, EjbClassRole classRole) {
        boolean canThrow = true;
        if (classRole.getMethodRole(method) == null) {
            for (PsiMethod deepestSuperMethod : method.findDeepestSuperMethods()) {
                if (deepestSuperMethod == null || !deepestSuperMethod.getContainingClass().getQualifiedName().startsWith("javax.ejb.")) continue;
                canThrow = false;
                break;
            }
        } else {
            canThrow = false;
        }
        if (!canThrow) {
            return EjbHighlightUtil.checkMethodThrows(holder, method, "java.rmi.RemoteException", false);
        }
        return false;
    }

    public static void checkClass(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        EjbHighlightUtil.checkClassIsInterface(holder, aClass, false);
        if (!EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, classRoles)) {
            return;
        }
        EjbClassBasicInspection.checkClassExtends(holder, aClass, classRoles);
        EjbClassBasicInspection.checkClassModifiers(holder, aClass, classRoles);
        EjbHighlightUtil.checkPublicNoArgsConstructorDefined(holder, aClass);
        EjbClassBasicInspection.checkBeanInterfacesImplemented(holder, aClass);
    }

    private static void checkBeanInterfacesImplemented(ProblemsHolder holder, PsiClass aClass) {
        Collection methods = OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)aClass, (boolean)true);
        StringBuilder sb = new StringBuilder();
        for (CandidateInfo candidateInfo : methods) {
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            if (aClass.isInheritor(method.getContainingClass(), true)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(method.getContainingClass().getName()).append('.').append(method.getName()).append('(');
            PsiParameter[] parameters = method.getParameterList().getParameters();
            boolean flag = false;
            for (PsiParameter psiParameter : parameters) {
                if (flag) {
                    sb.append(", ");
                } else {
                    flag = true;
                }
                sb.append(psiParameter.getType().getCanonicalText());
            }
            sb.append(')');
        }
        if (sb.length() > 0) {
            holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message("ejb.class.should.implement.interface.methods", aClass.getName(), sb.toString()), new LocalQuickFix[]{QuickFixFactory.getInstance().createImplementMethodsFix(aClass)});
        }
    }

    private static void checkClassModifiers(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        boolean checkedOnce = false;
        boolean shouldBeAbstract = false;
        boolean conflict = false;
        for (EjbClassRole role : classRoles) {
            if (role.getEnterpriseBean() == null) continue;
            boolean isAbstract = EjbUtil.isCMP(role.getEnterpriseBean(), CmpVersion.CmpVersion_2_X);
            if (checkedOnce && !conflict && shouldBeAbstract != isAbstract) {
                conflict = true;
                continue;
            }
            if (checkedOnce) continue;
            checkedOnce = true;
            shouldBeAbstract = isAbstract;
        }
        EjbHighlightUtil.checkClassModifier(holder, aClass, "public", true);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "final", false);
        if (conflict) {
            holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message("class.should.be.both.abstract.and.not.abstract", aClass.getQualifiedName()), new LocalQuickFix[0]);
        } else {
            EjbHighlightUtil.checkClassModifier(holder, aClass, "abstract", shouldBeAbstract);
        }
    }

    private static void checkFinalizeNotExists(ProblemsHolder holder, PsiMethod method) {
        if (method.getName().equals("finalize")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("ejb.class.should.not.define.method", method.getName()), new LocalQuickFix[0]);
        }
    }

    private static void checkClassExtends(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRole) {
        HashSet<String> mustImplement = new HashSet<String>();
        HashSet<String> mustNotImplement = new HashSet<String>();
        for (EjbClassRole role : classRole) {
            SessionType sessionType;
            boolean isEjb30;
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (ejb == null) continue;
            boolean bl = isEjb30 = EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejb.getEjbVersion()) <= 0;
            if (ejb instanceof SessionBean) {
                if (!isEjb30) {
                    mustImplement.add("javax.ejb.SessionBean");
                }
            } else if (ejb instanceof EntityBean) {
                mustImplement.add("javax.ejb.EntityBean");
            } else if (ejb instanceof MessageDrivenBean) {
                PsiClass listener;
                if (!isEjb30) {
                    mustImplement.add("javax.ejb.MessageDrivenBean");
                }
                if ((listener = (PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue()) != null) {
                    mustImplement.add(listener.getQualifiedName());
                }
            }
            SessionType sessionType2 = sessionType = ejb instanceof SessionBean ? (SessionType)((SessionBean)ejb).getSessionType().getValue() : null;
            if (sessionType == SessionType.STATEFUL && ((SessionBean)ejb).getTransactionManagementType().getValue() == TransactionType.CONTAINER) continue;
            mustNotImplement.add("javax.ejb.SessionSynchronization");
        }
        for (String interfaceName : mustImplement) {
            if (interfaceName == null) continue;
            EjbHighlightUtil.checkClassExtends(holder, aClass, interfaceName, true);
        }
        for (String interfaceName : mustNotImplement) {
            if (interfaceName == null) continue;
            EjbHighlightUtil.checkClassExtends(holder, aClass, interfaceName, false);
        }
    }

    private static void checkCreateMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean check = false;
        boolean checkThrowsCreate = false;
        boolean checkStateless = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_IMPL && role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_POST_CREATE_IMPL) continue;
            check = true;
            break;
        }
        if (!check) {
            return;
        }
        HashSet<PsiType> returnTypes = new HashSet<PsiType>();
        String methodName = method.getName();
        for (EjbMethodRole role : methodRoles) {
            PsiMethod correctCreateMethod;
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_IMPL && role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_POST_CREATE_IMPL) continue;
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (EjbUtil.isCMP(ejb, CmpVersion.CmpVersion_2_X) && role.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_IMPL) {
                checkThrowsCreate = true;
            }
            if (ejb instanceof SessionBean && ((SessionBean)ejb).getSessionType().getValue() != SessionType.STATEFUL) {
                checkStateless = true;
            }
            if ((correctCreateMethod = EjbUtil.getEjbCreateMethodPrototype(methodName, ejb, method)) == null || correctCreateMethod.getReturnType() == null) continue;
            returnTypes.add(correctCreateMethod.getReturnType());
        }
        if (checkThrowsCreate) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.CreateException", true);
        }
        if (checkStateless && (!methodName.endsWith("Create") || method.getParameterList().getParametersCount() > 0)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("stateless.session.bean.class.should.define.exactly.one.ejbcreate.method", new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createAddMethodFix("public void ejbCreate() throws javax.ejb.CreateException{}", method.getContainingClass(), new String[0])});
        }
        EjbHighlightUtil.checkMethodModifier(holder, method, "final", false);
        EjbHighlightUtil.checkMethodModifier(holder, method, "abstract", false);
        EjbHighlightUtil.checkMethodModifier(holder, method, "public", true);
        if (returnTypes.size() > 1) {
            holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingMessages.message("method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(returnTypes.toArray())), new LocalQuickFix[0]);
        } else if (returnTypes.size() == 1) {
            EjbHighlightUtil.checkMethodReturns(holder, method, (PsiType)returnTypes.iterator().next());
        }
    }
}

