/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.framework;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.framework.JavaeeProfileBasedFrameworkAvailabilityCondition;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EjbFrameworkVersion
extends JavaeeFrameworkVersionBase {
    private final EjbDescriptorVersion myDescriptorVersion;

    public EjbFrameworkVersion(@NotNull EjbDescriptorVersion descriptorVersion) {
        if (descriptorVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorVersion", "com/intellij/javaee/ejb/framework/EjbFrameworkVersion", "<init>"));
        }
        this.myDescriptorVersion = descriptorVersion;
    }

    public static List<EjbFrameworkVersion> getVersions() {
        ArrayList<EjbFrameworkVersion> versions = new ArrayList<EjbFrameworkVersion>();
        for (EjbDescriptorVersion version : EjbDescriptorVersion.values()) {
            versions.add(new EjbFrameworkVersion(version));
        }
        return versions;
    }

    @NotNull
    public String getId() {
        String string = this.myDescriptorVersion.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/framework/EjbFrameworkVersion", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myDescriptorVersion.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/framework/EjbFrameworkVersion", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        JavaeeProfileBasedFrameworkAvailabilityCondition javaeeProfileBasedFrameworkAvailabilityCondition = new JavaeeProfileBasedFrameworkAvailabilityCondition(this.myDescriptorVersion.getJavaeeVersion());
        if (javaeeProfileBasedFrameworkAvailabilityCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/framework/EjbFrameworkVersion", "getAvailabilityCondition"));
        }
        return javaeeProfileBasedFrameworkAvailabilityCondition;
    }

    public boolean isEjbJarDescriptorOptional() {
        return this.myDescriptorVersion.compareTo((Enum)EjbDescriptorVersion.EJB_VERSION_3_0) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myDescriptorVersion == ((EjbFrameworkVersion)o).myDescriptorVersion;
    }

    public int hashCode() {
        return this.myDescriptorVersion.hashCode();
    }

    @Override
    @NotNull
    public ConfigFileVersion getDescriptorVersion() {
        ConfigFileVersion configFileVersion = this.myDescriptorVersion.getConfigFileVersion();
        if (configFileVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/framework/EjbFrameworkVersion", "getDescriptorVersion"));
        }
        return configFileVersion;
    }
}

