/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NewEjbRoleHolder {
    private static final Key<CachedValue<Info>> XML_KEY = Key.create((String)"EJB_XML_ROLES");
    private static final Key<CachedValue<Info>> MERGED_KEY = Key.create((String)"EJB_MERGED_ROLES");
    private final Project myProject;

    public static NewEjbRoleHolder getInstance(Project project) {
        return (NewEjbRoleHolder)ServiceManager.getService((Project)project, NewEjbRoleHolder.class);
    }

    public NewEjbRoleHolder(PsiManager manager) {
        this.myProject = manager.getProject();
        CachedValue xmlValue = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)NewEjbRoleHolder.calculateXmlRoles(this.myProject), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
        this.myProject.putUserData(XML_KEY, (Object)xmlValue);
        CachedValue mergedValue = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)NewEjbRoleHolder.calculateMergedRoles(this.myProject), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
        this.myProject.putUserData(MERGED_KEY, (Object)mergedValue);
    }

    public EjbClassRole[] getXmlRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return NewEjbRoleHolder.getRoles(psiClass, (Info)((CachedValue)this.myProject.getUserData(XML_KEY)).getValue());
    }

    public EjbClassRole[] getAllXmlRoles() {
        List<EjbClassRole> roleList = ((Info)((CachedValue)this.myProject.getUserData(NewEjbRoleHolder.XML_KEY)).getValue()).allRoles;
        return roleList.toArray(new EjbClassRole[roleList.size()]);
    }

    public EjbClassRole[] getMergedRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return NewEjbRoleHolder.getRoles(psiClass, (Info)((CachedValue)this.myProject.getUserData(MERGED_KEY)).getValue());
    }

    public EjbClassRole[] getAllMergedRoles() {
        List<EjbClassRole> roleList = ((Info)((CachedValue)this.myProject.getUserData(NewEjbRoleHolder.MERGED_KEY)).getValue()).allRoles;
        return roleList.toArray(new EjbClassRole[roleList.size()]);
    }

    private static EjbClassRole[] getRoles(PsiClass psiClass, Info info) {
        if (info.map.isEmpty()) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        List<EjbClassRole> roleList = info.map.get(psiClass);
        if (roleList == null || roleList.isEmpty()) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return roleList.toArray(new EjbClassRole[roleList.size()]);
    }

    private static Info calculateMergedRoles(Project project) {
        Info info = new Info();
        for (EjbFacet ejbFacet : EjbUtil.getAllEjbFacets(project)) {
            EjbRootElement ejbRootElement = ejbFacet.getMergedRoot();
            NewEjbRoleHolder.processRootElement(info, ejbFacet, ejbRootElement);
        }
        return info;
    }

    private static Info calculateXmlRoles(Project project) {
        Info info = new Info();
        for (EjbFacet ejbFacet : EjbUtil.getAllEjbFacets(project)) {
            EjbJar ejbRootElement = ejbFacet.getXmlRoot();
            if (ejbRootElement == null) continue;
            NewEjbRoleHolder.processRootElement(info, ejbFacet, (EjbRootElement)ejbRootElement);
        }
        return info;
    }

    private static void processRootElement(Info info, EjbFacet ejbFacet, EjbRootElement ejbRootElement) {
        EnterpriseBeanSet enterpriseBeanSet = ejbRootElement.getEnterpriseBeans();
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getEntities(), true, false);
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getSessions(), true, true);
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getMessageDrivens(), false, false);
        for (Interceptor interceptor : ejbRootElement.getInterceptors().getInterceptors()) {
            NewEjbRoleHolder.processInterceptorClass(info, ejbFacet, (PsiClass)interceptor.getInterceptorClass().getValue(), interceptor);
        }
    }

    private static void processBeans(Info info, EjbFacet facet, Collection<? extends EnterpriseBean> beans, boolean withHome, boolean session) {
        for (EnterpriseBean enterpriseBean : beans) {
            info.allRoles.add(new EjbClassRoleImpl(EjbClassRoleEnum.EMPTY_ROLE, enterpriseBean, facet));
            NewEjbRoleHolder.processClass(info, (PsiClass)enterpriseBean.getEjbClass().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, facet, enterpriseBean);
            if (withHome) {
                EjbWithHome elementWithHome = (EjbWithHome)enterpriseBean;
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getHome().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getRemote().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getLocalHome().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getLocal().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE, facet, enterpriseBean);
            } else {
                NewEjbRoleHolder.processClass(info, (PsiClass)((MessageDrivenBean)enterpriseBean).getMessageListenerInterface().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE, facet, enterpriseBean);
            }
            if (!session) continue;
            SessionBean sessionBean = (SessionBean)enterpriseBean;
            NewEjbRoleHolder.processClass(info, (PsiClass)sessionBean.getServiceEndpoint().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE, facet, enterpriseBean);
            for (GenericValue genericValue : sessionBean.getBusinessLocals()) {
                NewEjbRoleHolder.processClass(info, (PsiClass)genericValue.getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE, facet, enterpriseBean);
            }
            for (GenericValue genericValue : sessionBean.getBusinessRemotes()) {
                NewEjbRoleHolder.processClass(info, (PsiClass)genericValue.getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE, facet, enterpriseBean);
            }
        }
    }

    private static void processInterceptorClass(Info info, EjbFacet facet, PsiClass psiClass, Interceptor interceptor) {
        info.allRoles.add(new EjbClassRoleImpl(EjbClassRoleEnum.EMPTY_ROLE, interceptor, facet));
        if (psiClass == null) {
            return;
        }
        EjbClassRoleImpl classRole = new EjbClassRoleImpl(EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS, interceptor, facet);
        NewEjbRoleHolder.processClass(info, psiClass, classRole);
    }

    private static void processClass(Info info, PsiClass psiClass, EjbClassRoleEnum ejbClassRole, EjbFacet facet, @NotNull EnterpriseBean ejb) {
        if (ejb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejb", "com/intellij/javaee/ejb/NewEjbRoleHolder", "processClass"));
        }
        if (psiClass != null) {
            NewEjbRoleHolder.processClass(info, psiClass, new EjbClassRoleImpl(ejbClassRole, ejb, facet));
        }
    }

    private static void processClass(Info info, PsiClass psiClass, EjbClassRoleImpl classRole) {
        ProgressManager.checkCanceled();
        ArrayList<PsiClass> psiClasses = new ArrayList<PsiClass>(5);
        psiClasses.add(psiClass);
        for (int i = 0; i < psiClasses.size(); ++i) {
            PsiClass curClass = (PsiClass)psiClasses.get(i);
            for (PsiClassType superClassType : curClass.getExtendsListTypes()) {
                String name;
                PsiClass superClass = superClassType.resolve();
                if (superClass == null || (name = superClass.getQualifiedName()) == null || name.startsWith("javax.ejb.") || name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || psiClasses.contains(superClass)) continue;
                psiClasses.add(superClass);
            }
        }
        for (PsiClass aClass : psiClasses) {
            List<EjbClassRole> roleList = info.map.get(aClass);
            if (roleList == null) {
                roleList = new ArrayList<EjbClassRole>(1);
                info.map.put(aClass, roleList);
            }
            roleList.add(classRole);
        }
    }

    private static class Info {
        final Map<PsiClass, List<EjbClassRole>> map = new THashMap();
        final List<EjbClassRole> allRoles = new ArrayList<EjbClassRole>();

        private Info() {
        }
    }
}

