/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.javaee.ejb.EjbView;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public class EjbToolWindowFactory
implements ToolWindowFactory {
    public static final String TOOL_WINDOW_ID = "EJB";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ejb/EjbToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/javaee/ejb/EjbToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(EjbFacetType.getInstance().getPresentableName());
        EjbView view = new EjbView(project);
        view.setupToolWindow((ToolWindowEx)toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(view.getComponent(), null, false);
        content.setDisposer((Disposable)view);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(view.getComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }
}

