/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ui.DeploymentSettingsPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AddModuleToDeployAction
extends AnAction {
    private final DeploymentSettingsPanel myPanel;

    public AddModuleToDeployAction(DeploymentSettingsPanel panel) {
        super("Module...", null, AllIcons.Nodes.Module);
        this.myPanel = panel;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(!this.getAvailableModules().isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = this.myPanel.getProject();
        List<Module> supportedModules = this.getAvailableModules();
        if (supportedModules.size() == 1) {
            this.addModule(project, supportedModules.get(0));
            return;
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, supportedModules, "Select Modules to Deploy", "Selected modules will be deployed at server startup");
        if (dialog.showAndGet()) {
            List chosen = dialog.getChosenElements();
            for (Module Module2 : chosen) {
                this.addModule(project, Module2);
            }
        }
    }

    private void addModule(Project project, Module Module2) {
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project).create(Module2);
        this.myPanel.addDeploymentModel((DeploymentSource)JavaeeDeploymentUtil.getInstance().createModuleDeploymentSource(pointer));
    }

    private List<Module> getAvailableModules() {
        Project project = this.myPanel.getProject();
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        ArrayList<Module> result = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        result.removeAll(this.myPanel.getAddedModules());
        return result;
    }
}

