/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DeploymentModelSettingsPanel
implements Disposable {
    private JPanel myMainPanel;
    private JComboBox myDeploymentMethodComboBox;
    private JPanel myDeploymentPropertiesPanel;
    private JLabel myDeploymentMethodLabel;
    private final SettingsEditor<DeploymentModel> myAdditionalEditor;

    public DeploymentModelSettingsPanel(@NotNull DeploymentModel model, @NotNull CommonStrategy configuration, @NotNull DeploymentProvider deploymentProvider) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel", "<init>"));
        }
        if (deploymentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentProvider", "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myDeploymentMethodComboBox.setRenderer(new DeploymentMethodListCellRenderer());
        this.myAdditionalEditor = deploymentProvider.createAdditionalDeploymentSettingsEditor((CommonModel)configuration, model.getDeploymentSource());
        if (this.myAdditionalEditor != null) {
            Disposer.register((Disposable)this, this.myAdditionalEditor);
            this.myDeploymentPropertiesPanel.add((Component)this.myAdditionalEditor.getComponent(), "Center");
        }
        this.updateDeploymentMethods(configuration, model);
    }

    public void loadFrom(DeploymentModel model) {
        this.myDeploymentMethodComboBox.setSelectedItem(model.getDeploymentMethod());
        if (this.myAdditionalEditor != null) {
            this.myAdditionalEditor.resetFrom((Object)model);
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void applyTo(DeploymentModel model) throws ConfigurationException {
        model.setDeploymentMethod((DeploymentMethod)this.myDeploymentMethodComboBox.getSelectedItem());
        if (this.myAdditionalEditor != null) {
            this.myAdditionalEditor.applyTo((Object)model);
        }
    }

    public void updateDeploymentMethods(CommonStrategy configuration, DeploymentModel deploymentModel) {
        DeploymentMethod[] availableMethods;
        Object selected = this.myDeploymentMethodComboBox.getSelectedItem();
        this.myDeploymentMethodComboBox.removeAllItems();
        boolean selectOldMethod = false;
        int applicableMethods = 0;
        for (DeploymentMethod method : availableMethods = deploymentModel.getAvailableMethods()) {
            if (!method.isApplicable((CommonModel)configuration)) continue;
            ++applicableMethods;
            this.myDeploymentMethodComboBox.addItem(method);
            if (!method.equals(selected)) continue;
            selectOldMethod = true;
        }
        this.myDeploymentMethodComboBox.setVisible(applicableMethods > 1);
        this.myDeploymentMethodLabel.setVisible(applicableMethods > 1);
        if (selectOldMethod) {
            this.myDeploymentMethodComboBox.setSelectedItem(selected);
        }
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentMethodLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.deployment.settings.deployment.method"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDeploymentMethodComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 3, 0, null, null, null));
        this.myDeploymentPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class DeploymentMethodListCellRenderer
    extends DefaultListCellRenderer {
        private DeploymentMethodListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DeploymentMethod) {
                DeploymentMethod deploymentMethod = (DeploymentMethod)value;
                this.setText(deploymentMethod.getName());
                this.setIcon(deploymentMethod.getIcon());
            }
            return this;
        }
    }
}

