/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.deployment.ExternalFileDeploymentProviderImpl;
import com.intellij.javaee.deployment.ExternalFileDeploymentSource;
import com.intellij.javaee.deployment.JavaeeArtifactDeploymentSourceImpl;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ModuleDeploymentSource;
import com.intellij.javaee.deployment.ModuleDeploymentSourceImpl;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JavaeeDeploymentUtilImpl
extends JavaeeDeploymentUtil {
    @NotNull
    public ArtifactDeploymentSource createArtifactDeploymentSource(@NotNull ArtifactPointer artifactPointer) {
        if (artifactPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPointer", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createArtifactDeploymentSource"));
        }
        JavaeeArtifactDeploymentSourceImpl javaeeArtifactDeploymentSourceImpl = new JavaeeArtifactDeploymentSourceImpl(artifactPointer);
        if (javaeeArtifactDeploymentSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createArtifactDeploymentSource"));
        }
        return javaeeArtifactDeploymentSourceImpl;
    }

    @NotNull
    public DeploymentSource createExternalFileDeploymentSource(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createExternalFileDeploymentSource"));
        }
        ExternalFileDeploymentSource externalFileDeploymentSource = new ExternalFileDeploymentSource(file);
        if (externalFileDeploymentSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createExternalFileDeploymentSource"));
        }
        return externalFileDeploymentSource;
    }

    @NotNull
    public ModuleDeploymentSource createModuleDeploymentSource(@NotNull ModulePointer modulePointer) {
        if (modulePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePointer", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createModuleDeploymentSource"));
        }
        ModuleDeploymentSourceImpl moduleDeploymentSourceImpl = new ModuleDeploymentSourceImpl(modulePointer);
        if (moduleDeploymentSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createModuleDeploymentSource"));
        }
        return moduleDeploymentSourceImpl;
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(@NotNull Collection<? extends ArtifactType> artifactTypes) {
        if (artifactTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactTypes", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createExternalFileDeploymentProvider"));
        }
        boolean directoriesAllowed = false;
        HashSet<String> allowedExtensions = new HashSet<String>();
        JavaeeArtifactUtil artifactUtil = JavaeeArtifactUtil.getInstance();
        for (ArtifactType artifactType : artifactTypes) {
            if (!artifactUtil.isArchive(artifactType)) {
                directoriesAllowed = true;
                continue;
            }
            if (artifactUtil.isEjbApplication(artifactType)) {
                allowedExtensions.add("jar");
                continue;
            }
            if (artifactUtil.isJavaeeApplication(artifactType)) {
                allowedExtensions.add("ear");
                continue;
            }
            if (!WebArtifactUtil.getInstance().isWebApplication(artifactType)) continue;
            allowedExtensions.add("war");
        }
        ExternalFileDeploymentProviderImpl externalFileDeploymentProviderImpl = new ExternalFileDeploymentProviderImpl(directoriesAllowed, allowedExtensions);
        if (externalFileDeploymentProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createExternalFileDeploymentProvider"));
        }
        return externalFileDeploymentProviderImpl;
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(boolean directoriesAllowed, String ... allowedExtensions) {
        ExternalFileDeploymentProviderImpl externalFileDeploymentProviderImpl = new ExternalFileDeploymentProviderImpl(directoriesAllowed, Arrays.asList(allowedExtensions));
        if (externalFileDeploymentProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl", "createExternalFileDeploymentProvider"));
        }
        return externalFileDeploymentProviderImpl;
    }
}

