/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.j2ee.openapi.impl.DeploymentManagerImpl;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.DeploymentViewEx;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.ToggleBuildOnFrameDeactivationAction;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class DeploymentViewImpl
implements DeploymentViewEx {
    private JPanel myMainPanel;
    private JList myArtifactsList;
    private final Project myProject;
    private final CommonStrategy myRunConfiguration;
    private final J2EEServerInstance myServerInstance;
    private DeploymentProvider myDeploymentProvider;

    public DeploymentViewImpl(Project project, CommonStrategy runConfiguration, DeploymentManagerImpl deploymentManager, J2EEServerInstance serverInstance) {
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myServerInstance = serverInstance;
        this.myDeploymentProvider = runConfiguration.getDeploymentProvider();
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myArtifactsList = new JBList();
        DefaultListModel<DeploymentModel> listModel = new DefaultListModel<DeploymentModel>();
        List deployed = runConfiguration.getDeploymentSettings().getDeploymentModels();
        for (DeploymentModel model : deployed) {
            listModel.addElement(model);
        }
        this.myArtifactsList.setModel(listModel);
        this.myArtifactsList.setCellRenderer(new DeployedArtifactsListCellRenderer());
        deploymentManager.addDeploymentListener(serverInstance, new JavaeeDeploymentListener(){

            public void deploymentStatusChanged(DeploymentModel model, DeploymentStatus newStatus, CommonModel runConfiguration) {
                ApplicationManager.getApplication().invokeLater(() -> DeploymentViewImpl.this.myArtifactsList.repaint());
            }
        }, this);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                DeploymentViewImpl.this.openContext();
                return true;
            }
        }.installOn((Component)this.myArtifactsList);
        this.myArtifactsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    e.consume();
                    DeploymentViewImpl.this.openContext();
                }
            }
        });
        this.myMainPanel.add(ScrollPaneFactory.createScrollPane((Component)this.myArtifactsList));
    }

    private void openContext() {
        List<DeploymentModel> selectedModels = this.getSelectedModels();
        if (selectedModels.isEmpty()) {
            return;
        }
        AppServerDeployedFileUrlProvider urlProvider = this.myRunConfiguration.getIntegration().getDeployedFileUrlProvider();
        for (DeploymentModel deploymentModel : selectedModels) {
            String url = urlProvider instanceof ApplicationServerUrlMapping ? ((ApplicationServerUrlMapping)urlProvider).getUrlForDeployedFile(this.myServerInstance, deploymentModel) : urlProvider.getUrlForDeployedFile(this.myServerInstance, deploymentModel, "/");
            if (url == null) continue;
            BrowserUtil.browse((String)url);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public JComponent getComponent() {
        return this.myMainPanel;
    }

    @Override
    public DefaultActionGroup createActionGroup() {
        String helpId;
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("JavaeeRunDeploymentViewToolbar"));
        if (UpdatingRunningApplicationUtil.isResourcesReloadingSupported(this.myRunConfiguration)) {
            group.add((AnAction)new ToggleBuildOnFrameDeactivationAction(this.myRunConfiguration));
        }
        if ((helpId = this.myDeploymentProvider.getHelpId()) != null) {
            group.addSeparator();
            group.add((AnAction)new ContextHelpAction(helpId));
        }
        return group;
    }

    public List<DeploymentModel> getSelectedModels() {
        ArrayList<DeploymentModel> result = new ArrayList<DeploymentModel>();
        for (Object selectedValue : this.myArtifactsList.getSelectedValues()) {
            result.add((DeploymentModel)selectedValue);
        }
        return result;
    }

    private class DeployedArtifactsListCellRenderer
    extends DefaultListCellRenderer {
        private DeployedArtifactsListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DeploymentModel model = (DeploymentModel)value;
            if (model != null) {
                this.setText(model.getDeploymentSource().getPresentableName());
                DeploymentStatus status = DeploymentManager.getInstance((Project)DeploymentViewImpl.this.myProject).getDeploymentStatus(model, (CommonModel)DeploymentViewImpl.this.myRunConfiguration);
                this.setIcon(status.getIcon(model.getDeploymentSource().getIcon()));
                this.setToolTipText(status.getDescription());
            }
            return component;
        }
    }
}

