/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.converting.artifacts.ContainerElementProcessor;
import com.intellij.javaee.converting.artifacts.PackagingMethod;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingConversionUtil {
    private static final String ARCHIVE_ID = PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE.getId();
    private static final String DIRECTORY_ID = PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE.getId();
    private static final String MODULE_OUTPUT_ID = ProductionModuleOutputElementType.ELEMENT_TYPE.getId();
    private static final String LIBRARY_ID = LibraryElementType.LIBRARY_ELEMENT_TYPE.getId();
    private static final String FILE_COPY_ID = PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE.getId();
    private static final String DIRECTORY_COPY_ID = PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE.getId();
    private static final String ARTIFACT_ID = ArtifactElementType.ARTIFACT_ELEMENT_TYPE.getId();
    @NonNls
    private static final String FACET_RESOURCES_ID = "javaee-facet-resources";
    @NonNls
    private static final String FACET_CLASSES_ID = "javaee-facet-classes";

    private PackagingConversionUtil() {
    }

    public static void processPackagingElements(@NotNull Element parent, ModuleSettings moduleSettings, ConversionContext context, @NotNull ContainerElementProcessor processor) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "processPackagingElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "processPackagingElements"));
        }
        PackagingConversionUtil.processPackagingElements(parent, moduleSettings, context, processor, false, true);
        PackagingConversionUtil.processPackagingElements(parent, moduleSettings, context, processor, true, false);
    }

    public static void processPackagingElements(@NotNull Element parent, ModuleSettings moduleSettings, ConversionContext context, @NotNull ContainerElementProcessor processor, boolean processFacetLinks, boolean processModulesAndLibraries) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "processPackagingElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "processPackagingElements"));
        }
        for (Element packagingElement : JDOMUtil.getChildren((Element)parent, (String)"containerElement")) {
            String relativePath = null;
            PackagingMethod packagingMethod = null;
            for (Element attributeElement : JDOMUtil.getChildren((Element)packagingElement, (String)"attribute")) {
                String name = attributeElement.getAttributeValue("name");
                String value = attributeElement.getAttributeValue("value");
                if ("URI".equals(name)) {
                    relativePath = value;
                    continue;
                }
                if (!"method".equals(name)) continue;
                packagingMethod = PackagingMethod.getDeploymentMethodById(value);
            }
            if (packagingMethod == null || packagingMethod.equals(PackagingMethod.DO_NOT_PACKAGE)) continue;
            String type = packagingElement.getAttributeValue("type");
            if ("facet".equals(type) && processFacetLinks) {
                String facetId = packagingElement.getAttributeValue("facetId");
                if (facetId == null) continue;
                processor.processFacetLink(facetId, relativePath, packagingMethod);
                continue;
            }
            if ("module".equals(type) && processModulesAndLibraries) {
                String moduleName = packagingElement.getAttributeValue("name");
                if (moduleName == null || relativePath == null) continue;
                processor.processModuleLink(moduleName, relativePath, packagingMethod);
                continue;
            }
            if (!"library".equals(type) || !processModulesAndLibraries) continue;
            String level = packagingElement.getAttributeValue("level");
            String libraryName = packagingElement.getAttributeValue("name");
            if (relativePath == null) continue;
            if (level != null && libraryName != null) {
                String moduleName = null;
                if ("module".equals(level)) {
                    moduleName = PackagingConversionUtil.findModuleWithLibrary(moduleSettings, libraryName).getModuleName();
                }
                processor.processLibraryLink(libraryName, level, moduleName, relativePath, packagingMethod);
                continue;
            }
            for (Element urlElement : JDOMUtil.getChildren((Element)packagingElement, (String)"url")) {
                String path = StringUtil.trimEnd((String)VfsUtil.urlToPath((String)urlElement.getTextTrim()), (String)"!/");
                processor.processLibraryFile(path, relativePath, packagingMethod);
            }
        }
    }

    @NotNull
    private static ModuleSettings findModuleWithLibrary(@NotNull ModuleSettings moduleSettings, @NotNull String libraryName) {
        if (moduleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSettings", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "findModuleWithLibrary"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "findModuleWithLibrary"));
        }
        Collection dependencies = moduleSettings.getAllModuleDependencies();
        for (ModuleSettings dependency : dependencies) {
            if (!dependency.hasModuleLibrary(libraryName)) continue;
            ModuleSettings moduleSettings2 = dependency;
            if (moduleSettings2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "findModuleWithLibrary"));
            }
            return moduleSettings2;
        }
        ModuleSettings moduleSettings3 = moduleSettings;
        if (moduleSettings3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "findModuleWithLibrary"));
        }
        return moduleSettings3;
    }

    public static Element getOrCreateParent(Element root, Element external, String outputPath, PackagingMethod packagingMethod) {
        boolean isJar = PackagingConversionUtil.isJar(packagingMethod);
        String parentDirectoryPath = isJar ? PathUtil.getParentPath((String)outputPath) : outputPath;
        Element actualRoot = PackagingConversionUtil.isExternal(packagingMethod) ? external : root;
        Element directory = PackagingConversionUtil.getOrCreateDirectory(actualRoot, parentDirectoryPath);
        return isJar ? PackagingConversionUtil.getOrCreateChild(directory, PathUtil.getFileName((String)outputPath), true) : directory;
    }

    public static Element getParentPlace(Element root, Element external, String outputPath) {
        if ((outputPath = PackagingConversionUtil.trimSlashes(outputPath)).length() == 0) {
            return external;
        }
        return PackagingConversionUtil.getOrCreateDirectory(root, PathUtil.getParentPath((String)outputPath));
    }

    public static boolean isJar(PackagingMethod packagingMethod) {
        return packagingMethod == PackagingMethod.JAR_AND_COPY_FILE || packagingMethod == PackagingMethod.JAR_AND_COPY_FILE_AND_LINK_VIA_MANIFEST;
    }

    public static boolean isExternal(PackagingMethod packagingMethod) {
        return packagingMethod == PackagingMethod.COPY_FILES_AND_LINK_VIA_MANIFEST || packagingMethod == PackagingMethod.JAR_AND_COPY_FILE_AND_LINK_VIA_MANIFEST;
    }

    public static Element createArtifactRoot() {
        return PackagingConversionUtil.createPackagingElement(PackagingElementFactoryImpl.ARTIFACT_ROOT_ELEMENT_TYPE.getId());
    }

    public static Element getOrCreateDirectory(Element root, String relativePath) {
        if ((relativePath = PackagingConversionUtil.trimSlashes(relativePath)).length() == 0) {
            return root;
        }
        Element parent = PackagingConversionUtil.getOrCreateDirectory(root, PathUtil.getParentPath((String)relativePath));
        return PackagingConversionUtil.getOrCreateChild(parent, PathUtil.getFileName((String)relativePath), false);
    }

    private static String trimSlashes(String relativePath) {
        return StringUtil.trimStart((String)StringUtil.trimEnd((String)relativePath, (String)"/"), (String)"/");
    }

    public static Element getOrCreateChild(Element parent, String name, boolean archive) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (archive && ARCHIVE_ID.equals(child.getAttributeValue("id")) && name.equals(child.getAttributeValue("name"))) {
                return child;
            }
            if (archive || !DIRECTORY_ID.equals(child.getAttributeValue("id")) || !name.equals(child.getAttributeValue("name"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createDirectoryOrArchive(name, archive);
        parent.addContent(element);
        return element;
    }

    public static Element createDirectoryOrArchive(String name, boolean archive) {
        Element element = PackagingConversionUtil.createPackagingElement(archive ? ARCHIVE_ID : DIRECTORY_ID);
        element.setAttribute(archive ? "name" : "name", name);
        return element;
    }

    public static Element createPackagingElement(String typeId) {
        Element element = new Element("element");
        element.setAttribute("id", typeId);
        return element;
    }

    public static Element addModuleOutput(Element parent, String moduleName) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!MODULE_OUTPUT_ID.equals(child.getAttributeValue("id")) || !moduleName.equals(child.getAttributeValue("name"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(MODULE_OUTPUT_ID);
        element.setAttribute("name", moduleName);
        parent.addContent(element);
        return element;
    }

    public static Element addLibrary(Element parent, String libraryName, String level, @Nullable String moduleName) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!LIBRARY_ID.equals(child.getAttributeValue("id")) || !libraryName.equals(child.getAttributeValue("name")) || !level.equals(child.getAttributeValue("level")) || !Comparing.equal((String)moduleName, (String)child.getAttributeValue("module-name"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(LIBRARY_ID);
        element.setAttribute("level", level);
        element.setAttribute("name", libraryName);
        if (moduleName != null) {
            element.setAttribute("module-name", moduleName);
        }
        parent.addContent(element);
        return element;
    }

    public static Element addFileCopy(Element parent, String path, @Nullable String fileName) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!FILE_COPY_ID.equals(child.getAttributeValue("id")) || !path.equals(child.getAttributeValue("path")) || !Comparing.equal((String)fileName, (String)child.getAttributeValue("output-file-name"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(FILE_COPY_ID);
        element.setAttribute("path", path);
        if (fileName != null) {
            element.setAttribute("output-file-name", fileName);
        }
        parent.addContent(element);
        return element;
    }

    public static Element addDirectoryCopy(Element parent, String path) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!DIRECTORY_COPY_ID.equals(child.getAttributeValue("id")) || !path.equals(child.getAttributeValue("path"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(DIRECTORY_COPY_ID);
        element.setAttribute("path", path);
        parent.addContent(element);
        return element;
    }

    public static Element addArtifact(Element parent, String name) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!ARTIFACT_ID.equals(child.getAttributeValue("id")) || !name.equals(child.getAttributeValue("artifact-name"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(ARTIFACT_ID);
        element.setAttribute("artifact-name", name);
        parent.addContent(element);
        return element;
    }

    public static Element addFacetClasses(Element parent, String facetPointer) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!FACET_CLASSES_ID.equals(child.getAttributeValue("id")) || !facetPointer.equals(child.getAttributeValue("facet"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(FACET_CLASSES_ID);
        element.setAttribute("facet", facetPointer);
        parent.addContent(element);
        return element;
    }

    public static Element addFacetResources(Element parent, String facetPointer) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"element")) {
            if (!FACET_RESOURCES_ID.equals(child.getAttributeValue("id")) || !facetPointer.equals(child.getAttributeValue("facet"))) continue;
            return child;
        }
        Element element = PackagingConversionUtil.createPackagingElement(FACET_RESOURCES_ID);
        element.setAttribute("facet", facetPointer);
        parent.addContent(element);
        return element;
    }

    public static Element addElement(Element parent, Element element, MultiValuesMap<Element, Element> includedElements) {
        String type = element.getAttributeValue("id");
        if (FILE_COPY_ID.equals(type)) {
            return PackagingConversionUtil.addFileCopy(parent, element.getAttributeValue("path"), element.getAttributeValue("output-file-name"));
        }
        if (DIRECTORY_COPY_ID.equals(type)) {
            return PackagingConversionUtil.addDirectoryCopy(parent, element.getAttributeValue("path"));
        }
        if (MODULE_OUTPUT_ID.equals(type)) {
            return PackagingConversionUtil.addModuleOutput(parent, element.getAttributeValue("name"));
        }
        if (LIBRARY_ID.equals(type)) {
            return PackagingConversionUtil.addLibrary(parent, element.getAttributeValue("name"), element.getAttributeValue("level"), element.getAttributeValue("module-name"));
        }
        if (ARTIFACT_ID.equals(type)) {
            return PackagingConversionUtil.addArtifact(parent, element.getAttributeValue("artifact-name"));
        }
        if (ARCHIVE_ID.equals(type)) {
            Element child = PackagingConversionUtil.getOrCreateChild(parent, element.getAttributeValue("name"), true);
            PackagingConversionUtil.addChildElements(child, element, includedElements);
            return child;
        }
        if (DIRECTORY_ID.equals(type)) {
            Element child = PackagingConversionUtil.getOrCreateChild(parent, element.getAttributeValue("name"), false);
            PackagingConversionUtil.addChildElements(child, element, includedElements);
            return child;
        }
        if (FACET_RESOURCES_ID.equals(type)) {
            return PackagingConversionUtil.addFacetResources(parent, element.getAttributeValue("facet"));
        }
        if (FACET_CLASSES_ID.equals(type)) {
            return PackagingConversionUtil.addFacetClasses(parent, element.getAttributeValue("facet"));
        }
        parent.addContent(element.clone());
        return element;
    }

    public static void addChildElements(Element parent, Element element, MultiValuesMap<Element, Element> includedElements) {
        for (Element child : JDOMUtil.getChildren((Element)element, (String)"element")) {
            Element newChild = PackagingConversionUtil.addElement(parent, child, includedElements);
            Collection included = includedElements.get((Object)child);
            if (included == null) continue;
            includedElements.removeAll((Object)child);
            for (Element includedElement : included) {
                PackagingConversionUtil.addChildElements(newChild, includedElement, includedElements);
            }
        }
    }

    public static void updateManifestFile(@NotNull File directory, final List<String> classpath, final String mainClass) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil", "updateManifestFile"));
        }
        final File manifestFile = new File(new File(directory, ManifestFileUtil.MANIFEST_DIR_NAME), ManifestFileUtil.MANIFEST_FILE_NAME);
        FileUtil.createIfDoesntExist((File)manifestFile);
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/converting/artifacts/PackagingConversionUtil$1", "run"));
                }
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(manifestFile);
                ManifestFileUtil.updateManifest((VirtualFile)file, (String)mainClass, (List)classpath, (boolean)false);
            }
        }.execute();
    }

    public static String getFacetPointer(ModuleSettings moduleSettings, Element facetElement) {
        String facetType = facetElement.getAttributeValue("type");
        String facetName = facetElement.getAttributeValue("name");
        return FacetPointersManager.constructId((String)moduleSettings.getModuleName(), (String)facetType, (String)facetName);
    }
}

