/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.javaee.converting.artifacts.ContainerElementProcessorBase;
import com.intellij.javaee.converting.artifacts.JarPackagingConverter;
import com.intellij.javaee.converting.artifacts.PackagingConversionUtil;
import com.intellij.javaee.converting.artifacts.PackagingMethod;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public class ModuleJarSettingsConversionProcessor
extends ConversionProcessor<ModuleSettings> {
    private final JarPackagingConverter myConverter;
    @NonNls
    private static final String ELEMENT_CONTAINER_INFO = "containerInfo";
    @NonNls
    private static final String BUILD_JAR_SETTINGS_COMPONENT_NAME = "BuildJarSettings";
    @NonNls
    private static final String JAR_URL_ATTRIBUTE = "jarUrl";
    @NonNls
    private static final String MAIN_CLASS_ATTRIBUTE = "mainClass";

    public ModuleJarSettingsConversionProcessor(JarPackagingConverter converter) {
        this.myConverter = converter;
    }

    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        return moduleSettings.getComponentElement(BUILD_JAR_SETTINGS_COMPONENT_NAME) != null;
    }

    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        Element component = moduleSettings.getComponentElement(BUILD_JAR_SETTINGS_COMPONENT_NAME);
        if (component != null) {
            Element packaging;
            String jarPath = VfsUtil.urlToPath((String)JDOMExternalizer.readString((Element)component, (String)JAR_URL_ATTRIBUTE));
            String mainClass = JDOMExternalizer.readString((Element)component, (String)MAIN_CLASS_ATTRIBUTE);
            if (StringUtil.isEmpty((String)mainClass)) {
                mainClass = null;
            }
            if ((packaging = component.getChild(ELEMENT_CONTAINER_INFO)) != null) {
                String jarName = PathUtil.getFileName((String)jarPath);
                if (jarName.length() == 0) {
                    jarName = moduleSettings.getModuleName() + ".jar";
                }
                Element root = PackagingConversionUtil.createArtifactRoot();
                Element jar = PackagingConversionUtil.getOrCreateChild(root, jarName, true);
                JarPackagingProcessor processor = new JarPackagingProcessor(jar, root, moduleSettings, this.myConverter);
                PackagingConversionUtil.processPackagingElements(packaging, moduleSettings, this.myConverter.getContext(), processor);
                ArtifactState state = new ArtifactState();
                state.setName(moduleSettings.getModuleName() + ":jar");
                state.setRootElement(root);
                String outputPath = PathUtil.getParentPath((String)jarPath);
                if (outputPath.length() > 0) {
                    state.setOutputPath(this.myConverter.expandModuleMacros(outputPath, moduleSettings));
                }
                state.setArtifactType("plain");
                List<String> classpath = processor.getClasspath();
                File dir = processor.getSourceDir();
                if (classpath != null || mainClass != null) {
                    if (dir == null && (dir = (File)ContainerUtil.getFirstItem((Collection)moduleSettings.getContentRoots(), null)) != null) {
                        Element parent = PackagingConversionUtil.getOrCreateDirectory(jar, ManifestFileUtil.MANIFEST_DIR_NAME);
                        PackagingConversionUtil.addFileCopy(parent, FileUtil.toSystemIndependentName((String)dir.getAbsolutePath()) + "/" + "META-INF/MANIFEST.MF", null);
                    }
                    if (dir != null) {
                        PackagingConversionUtil.updateManifestFile(dir, classpath, mainClass);
                    }
                }
                this.myConverter.addArtifact(state);
            }
            component.detach();
        }
    }

    private static class JarPackagingProcessor
    extends ContainerElementProcessorBase<JarPackagingConverter> {
        private List<String> myClasspath;
        private File mySourceDir;

        private JarPackagingProcessor(Element root, Element external, ModuleSettings moduleSettings, JarPackagingConverter converter) {
            super(root, external, moduleSettings, converter);
        }

        @Override
        public void processModuleLink(@NotNull String moduleName, @NotNull String outputPath, @NotNull PackagingMethod packagingMethod) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javaee/converting/artifacts/ModuleJarSettingsConversionProcessor$JarPackagingProcessor", "processModuleLink"));
            }
            if (outputPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/javaee/converting/artifacts/ModuleJarSettingsConversionProcessor$JarPackagingProcessor", "processModuleLink"));
            }
            if (packagingMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagingMethod", "com/intellij/javaee/converting/artifacts/ModuleJarSettingsConversionProcessor$JarPackagingProcessor", "processModuleLink"));
            }
            this.addToClasspath(packagingMethod, outputPath);
            Element parent = PackagingConversionUtil.getOrCreateParent(this.myRoot, this.myExternal, outputPath, packagingMethod);
            PackagingConversionUtil.addModuleOutput(parent, moduleName);
            if (packagingMethod == PackagingMethod.COPY_FILES && PathUtil.getFileName((String)outputPath).length() == 0 && moduleName.equals(this.myModuleSettings.getModuleName())) {
                this.mySourceDir = (File)ContainerUtil.getFirstItem((Collection)this.myModuleSettings.getSourceRoots(false), null);
            }
        }

        public List<String> getClasspath() {
            return this.myClasspath;
        }

        public File getSourceDir() {
            return this.mySourceDir;
        }

        @Override
        protected List<String> getOrCreateClasspath() {
            if (this.myClasspath == null) {
                this.myClasspath = new ArrayList<String>();
            }
            return this.myClasspath;
        }
    }
}

