/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.application.framework;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.framework.JavaeeProfileBasedFrameworkAvailabilityCondition;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeApplicationFrameworkVersion
extends JavaeeFrameworkVersionBase {
    private JavaeeVersion myVersion;

    public JavaeeApplicationFrameworkVersion(JavaeeVersion version) {
        this.myVersion = version;
    }

    public static List<JavaeeApplicationFrameworkVersion> getAllVersions() {
        ArrayList<JavaeeApplicationFrameworkVersion> versions = new ArrayList<JavaeeApplicationFrameworkVersion>();
        for (JavaeeVersion version : JavaeeVersion.values()) {
            versions.add(new JavaeeApplicationFrameworkVersion(version));
        }
        return versions;
    }

    @NotNull
    public String getId() {
        String string = this.myVersion.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myVersion.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        JavaeeProfileBasedFrameworkAvailabilityCondition javaeeProfileBasedFrameworkAvailabilityCondition = new JavaeeProfileBasedFrameworkAvailabilityCondition(this.myVersion);
        if (javaeeProfileBasedFrameworkAvailabilityCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getAvailabilityCondition"));
        }
        return javaeeProfileBasedFrameworkAvailabilityCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myVersion == ((JavaeeApplicationFrameworkVersion)o).myVersion;
    }

    public int hashCode() {
        return this.myVersion.hashCode();
    }

    @Override
    @NotNull
    public ConfigFileVersion getDescriptorVersion() {
        switch (this.myVersion) {
            case J2EE_1_4: {
                ConfigFileVersion configFileVersion = DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_1_4;
                if (configFileVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getDescriptorVersion"));
                }
                return configFileVersion;
            }
            case JAVAEE_5: {
                ConfigFileVersion configFileVersion = DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_5_0;
                if (configFileVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getDescriptorVersion"));
                }
                return configFileVersion;
            }
            case JAVAEE_6: {
                ConfigFileVersion configFileVersion = DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_6_0;
                if (configFileVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getDescriptorVersion"));
                }
                return configFileVersion;
            }
            case JAVAEE_7: {
                ConfigFileVersion configFileVersion = DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_6_0;
                if (configFileVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/framework/JavaeeApplicationFrameworkVersion", "getDescriptorVersion"));
                }
                return configFileVersion;
            }
        }
        throw new IllegalStateException(String.valueOf(this.myVersion));
    }
}

