/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class EjbOverridingMethodSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters p, final @NotNull Processor<PsiMethod> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/javaee/EjbOverridingMethodSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/EjbOverridingMethodSearcher", "execute"));
        }
        final PsiMethod method = p.getMethod();
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (EjbMethodRole ejbRole : OldEjbRolesUtil.getEjbRoles(method)) {
                    PsiMethod[] implementations;
                    if (!(ejbRole instanceof EjbDeclMethodRoleImpl)) continue;
                    for (PsiMethod implementation : implementations = ((EjbDeclMethodRole)ejbRole).findImplementationsInEjbClass()) {
                        if (implementation.getSignature(PsiSubstitutor.EMPTY).equals(method.getSignature(PsiSubstitutor.EMPTY)) || consumer.process((Object)implementation)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

