/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.EjbType;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.model.enums.TransactionType;
import com.intellij.javaee.model.xml.compatibility.AcknowledgeMode;
import com.intellij.javaee.model.xml.compatibility.SubscriptionDurabilityType;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EjbWithHome;
import com.intellij.javaee.model.xml.ejb.EnterpriseBeans;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MessageDrivenBean;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbClassesPropertiesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.NamedEnumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbDataHolder {
    @NonNls
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    @NonNls
    private static final String EJB_NAME = "Ejb_Name";
    @NonNls
    private static final String REMOTE_INTERFACE_NAME_PROPERTY = "Remote_Interface_Name";
    @NonNls
    private static final String LOCAL_NTERFACE_NAME_PROPERTY = "Local_Interface_Name";
    @NonNls
    private static final String SERVICE_ENDPOINT_INTERFACE = "Service_Endpoint_Interface_Name";
    @NonNls
    private static final String PK_CLASS_NAME_PROPERTY = "PK_Class_Name";
    @NonNls
    private static final String MESSAGE_LISTENER_INTERFACE = "Message_Listener_Interface_Name";
    private String myName;
    private String myClassName;
    private PsiDirectory myClassDirectory;
    private final JavaeeCodeStyleSettings myCodeStyleSettings;
    private final Module myModule;
    private final EjbFacet myEjbFacet;
    private final String myOldName;
    private String remoteInterfaceName;
    private String remoteHomeInterfaceName;
    private boolean generateRemote;
    private String localInterfaceName;
    private String localHomeInterfaceName;
    private boolean generateLocal;
    private EjbType ejbType;
    private PersistenceType myPersistenceType;
    private String myPkClassName;
    private boolean myCreateClasses;
    private CmpVersion myCmpVersion;
    private TransactionType myTransactionType;
    private SessionType mySessionType;
    private String myAbstractSchemaName;
    private AcknowledgeMode myAcknowledgeMode;
    private String myDestinationType;
    private SubscriptionDurabilityType myDurability;
    private String myServiceEndpointInterface;
    private String myMessageListenerInterface;
    private boolean myGenerateServiceEndpoint;

    public EjbDataHolder(EjbBase ejb) {
        this((JavaeeModelElement)ejb, (String)ejb.getEjbName().getValue());
        if (ejb instanceof EntityBean) {
            this.setEjbType(EjbType.Entity);
            EntityBean entityBean = (EntityBean)ejb;
            this.setPkClassName(entityBean.getPrimKeyClass().getStringValue());
            this.myPersistenceType = (PersistenceType)entityBean.getPersistenceType().getValue();
            this.setPkClassName(entityBean.getPrimKeyClass().getStringValue());
            this.setCmpVersion((CmpVersion)entityBean.getCmpVersion().getValue());
            this.myAbstractSchemaName = (String)entityBean.getAbstractSchemaName().getValue();
        } else if (ejb instanceof SessionBean) {
            this.setEjbType(EjbType.Session);
            SessionBean sessionBean = (SessionBean)ejb;
            this.myTransactionType = (TransactionType)sessionBean.getTransactionManagementType().getValue();
            this.mySessionType = (SessionType)sessionBean.getSessionType().getValue();
            this.setServiceEndpointInterface(sessionBean.getServiceEndpoint().getStringValue());
        } else if (ejb instanceof MessageDrivenBean) {
            MessageDrivenBean messageBean = (MessageDrivenBean)ejb;
            this.myTransactionType = (TransactionType)((MessageDrivenBean)ejb).getTransactionType().getValue();
            this.setEjbType(EjbType.Message);
            if (messageBean.usesOldJmsOnlyStyle()) {
                this.myAcknowledgeMode = (AcknowledgeMode)messageBean.getAcknowledgeMode().getValue();
                this.myDestinationType = messageBean.getMessageDrivenDestination().getDestinationType().getStringValue();
                this.myDurability = (SubscriptionDurabilityType)messageBean.getMessageDrivenDestination().getSubscriptionDurability().getValue();
            } else {
                this.myDestinationType = messageBean.getMessageDestinationType().getStringValue();
                this.myAcknowledgeMode = (AcknowledgeMode)NamedEnumUtil.getEnumElementByValue(AcknowledgeMode.class, (String)messageBean.getActivationConfigProperty("acknowledgeMode"));
                this.myDurability = (SubscriptionDurabilityType)NamedEnumUtil.getEnumElementByValue(SubscriptionDurabilityType.class, (String)messageBean.getActivationConfigProperty("subscriptionDurability"));
            }
            this.setMessageListenerInterface(messageBean.getMessageListenerInterface().getStringValue());
        }
        this.setName((String)ejb.getEjbName().getValue());
        this.setClassName(ejb.getEjbClass().getStringValue());
        if (ejb instanceof EjbWithHome) {
            EjbWithHome elementWithHome = (EjbWithHome)ejb;
            this.setRemoteHomeInterfaceName(elementWithHome.getHome().getStringValue());
            this.setRemoteInterfaceName(elementWithHome.getRemote().getStringValue());
            this.setGenerateRemote(elementWithHome.getHome().getStringValue() != null && elementWithHome.getRemote().getStringValue() != null);
            this.setLocalHomeInterfaceName(elementWithHome.getLocalHome().getStringValue());
            this.setLocalInterfaceName(elementWithHome.getLocal().getStringValue());
            this.setGenerateLocal(elementWithHome.getLocalHome().getStringValue() != null && elementWithHome.getLocal().getStringValue() != null);
            if (ejb instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)ejb;
                this.setGenerateServiceEndpoint(sessionBean.getServiceEndpoint().getStringValue() != null);
            }
        }
        this.myCreateClasses = false;
    }

    public EjbDataHolder(EjbRootElement ejbModel, EjbType type) {
        this((JavaeeModelElement)ejbModel, (String)null);
        EjbDescriptorVersion ejbVersion = EjbUtil.getVersion((JavaeeModelElement)ejbModel);
        boolean ejb30 = EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbVersion) <= 0;
        this.ejbType = type;
        this.setName(this.getUniqueName());
        String pureName = this.getPureName();
        this.setClassName(this.ejbType.getClassNamePrefix(this.myCodeStyleSettings) + pureName + this.ejbType.getClassNameSuffix(this.myCodeStyleSettings));
        this.myCreateClasses = true;
        Project project = this.myModule.getProject();
        JavaeeCodeStyleSettings settings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaeeCodeStyleSettings.class);
        this.setPkClassName(settings.ENTITY_PK_CLASS);
        CmpVersion cmpVersion = this.myCmpVersion = EjbUtil.isEjbVersion1x((JavaeeModelElement)ejbModel) ? CmpVersion.CmpVersion_1_X : CmpVersion.CmpVersion_2_X;
        if (this.ejbType == EjbType.Message) {
            this.myTransactionType = TransactionType.CONTAINER;
            this.generateRemote = false;
            this.generateLocal = false;
            this.myGenerateServiceEndpoint = false;
            this.myAcknowledgeMode = AcknowledgeMode.Auto_Acknowledge;
            this.myDestinationType = "javax.jms.Queue";
            this.myDurability = SubscriptionDurabilityType.DURABLE;
            this.myMessageListenerInterface = "javax.jms.MessageListener";
        } else if (this.ejbType == EjbType.Session) {
            this.myTransactionType = TransactionType.CONTAINER;
            this.mySessionType = SessionType.STATELESS;
            this.generateRemote = !ejb30;
            this.generateLocal = false;
            this.myGenerateServiceEndpoint = false;
        } else {
            this.generateRemote = true;
            this.generateLocal = false;
            this.myGenerateServiceEndpoint = false;
        }
    }

    private EjbDataHolder(JavaeeModelElement element, String oldName) {
        this.myModule = element.getModule();
        this.myEjbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)element);
        this.myOldName = oldName;
        this.myCodeStyleSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myModule.getProject()).getCustomSettings(JavaeeCodeStyleSettings.class);
    }

    public final Module getModule() {
        return this.myModule;
    }

    public final EjbBase createEjb(EnterpriseBeans beans) {
        EjbBase base = (EjbBase)this.ejbType.createEjb(beans).createStableCopy();
        this.myAbstractSchemaName = this.myName;
        this.installTo(base);
        return base;
    }

    public void setClassDirectory(PsiDirectory classDirectory) {
        this.myClassDirectory = classDirectory;
    }

    public void installTo(EjbBase ejb) {
        ejb.getEjbName().setValue((Object)this.getName());
        ejb.getEjbClass().setStringValue(this.getClassName());
        if (ejb instanceof EjbWithHome) {
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            ejbWithHome.getLocalHome().setStringValue(this.getLocalHomeInterfaceName());
            ejbWithHome.getLocal().setStringValue(this.getLocalInterfaceName());
            ejbWithHome.getHome().setStringValue(this.getRemoteHomeInterfaceName());
            ejbWithHome.getRemote().setStringValue(this.getRemoteInterfaceName());
            if (ejb instanceof EntityBean) {
                EntityBean entityBean = (EntityBean)ejb;
                PersistenceType persistenceType = this.getPersistenceType();
                entityBean.getPersistenceType().setStringValue(persistenceType.getValue());
                entityBean.getPrimKeyClass().setStringValue(this.getPKClassName());
                entityBean.getReentrant().setValue((Object)Boolean.TRUE);
                entityBean.getCmpVersion().setValue((Object)(persistenceType == PersistenceType.CONTAINER ? this.getCmpVersion() : null));
                if (EjbUtil.isCMP((EnterpriseBean)ejb, CmpVersion.CmpVersion_2_X)) {
                    entityBean.getAbstractSchemaName().setStringValue(this.myAbstractSchemaName);
                }
            } else {
                SessionBean sessionBean = (SessionBean)ejb;
                sessionBean.getTransactionType().setValue((Object)this.myTransactionType);
                sessionBean.getSessionType().setValue((Object)this.mySessionType);
                sessionBean.getServiceEndpoint().setStringValue(this.getServiceEndpointInterface());
            }
        } else {
            MessageDrivenBean messageDrivenBean = (MessageDrivenBean)ejb;
            messageDrivenBean.getTransactionType().setValue((Object)this.myTransactionType);
            if (messageDrivenBean.usesOldJmsOnlyStyle()) {
                messageDrivenBean.getAcknowledgeMode().setValue((Object)this.myAcknowledgeMode);
                messageDrivenBean.getMessageDrivenDestination().getDestinationType().setStringValue(this.myDestinationType);
                messageDrivenBean.getMessageDrivenDestination().getSubscriptionDurability().setValue((Object)this.myDurability);
            } else {
                messageDrivenBean.getMessageDestinationType().setStringValue(this.myDestinationType);
                messageDrivenBean.getMessagingType().setStringValue(this.getMessageListenerInterface());
                messageDrivenBean.setActivationConfigProperty("acknowledgeMode", NamedEnumUtil.getEnumValueByElement((Enum)this.myAcknowledgeMode));
                messageDrivenBean.setActivationConfigProperty("subscriptionDurability", NamedEnumUtil.getEnumValueByElement((Enum)this.myDurability));
                messageDrivenBean.setActivationConfigProperty("destinationType", this.myDestinationType);
            }
        }
        if (this.myCreateClasses) {
            this.createEjbClasses(ejb.getModule());
        }
    }

    public List<PsiClass> createEjbClasses(Module module) {
        PsiDirectory classDirectory = this.getOrCreateClassDirectory(module);
        if (classDirectory == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (Pair<String, String> pair : EjbClassesPropertiesDialog.collectRequiredClasses(this)) {
            try {
                result.add(this.createClass((String)pair.getFirst(), (String)pair.getSecond(), classDirectory));
            }
            catch (IncorrectOperationException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(e);
                }
                Messages.showErrorDialog((String)e.getMessage(), (String)J2EEBundle.message((String)"dialog.title.cant.create.class", (Object[])new Object[0]));
                return result;
            }
        }
        return result;
    }

    @Nullable
    public PsiClass createClass(String newClassName, String templateName, @NotNull PsiDirectory classDirectory) throws IncorrectOperationException {
        if (classDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDirectory", "com/intellij/javaee/EjbDataHolder", "createClass"));
        }
        PsiClass existing = JavaPsiFacade.getInstance((Project)classDirectory.getProject()).findClass(newClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (existing != null) {
            return existing;
        }
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)classDirectory.getProject()).getDefaultProperties());
        EjbDataHolder.setProperty(properties, EJB_NAME, this.getName());
        EjbDataHolder.setProperty(properties, PACKAGE_NAME, this.getPackage());
        if (this.ejbType == EjbType.Session || this.ejbType == EjbType.Entity) {
            EjbDataHolder.setProperty(properties, REMOTE_INTERFACE_NAME_PROPERTY, this.getRemoteInterfaceName());
            EjbDataHolder.setProperty(properties, LOCAL_NTERFACE_NAME_PROPERTY, this.getLocalInterfaceName());
            if (this.ejbType == EjbType.Entity) {
                EjbDataHolder.setProperty(properties, PK_CLASS_NAME_PROPERTY, this.getPKClassName());
            } else if (this.mySessionType != SessionType.STATEFUL) {
                EjbDataHolder.setProperty(properties, SERVICE_ENDPOINT_INTERFACE, this.getServiceEndpointInterface());
            }
        } else if (this.ejbType == EjbType.Message) {
            EjbDataHolder.setProperty(properties, MESSAGE_LISTENER_INTERFACE, this.getMessageListenerInterface());
        }
        PsiClass psiClass = CreateClassUtil.createClassNamed((String)newClassName, (Map)properties, (String)templateName, (PsiDirectory)classDirectory);
        if (psiClass != null && !psiClass.isInterface()) {
            Collection candidates = OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)psiClass, (boolean)true);
            List psiMethods = OverrideImplementUtil.overrideOrImplementMethodCandidates((PsiClass)psiClass, (Collection)candidates, (boolean)false);
            for (PsiMethod psiMethod : psiMethods) {
                psiClass.addBefore((PsiElement)psiMethod, null);
            }
        }
        return psiClass;
    }

    private static void setProperty(Map<Object, Object> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public void setPersistenceType(PersistenceType persistenceType) {
        this.myPersistenceType = persistenceType;
    }

    public void setSessionType(SessionType sessionType) {
        this.mySessionType = sessionType;
    }

    @Nullable
    private PsiDirectory getOrCreateClassDirectory(Module module) {
        PsiDirectory classDirectory = this.myClassDirectory;
        if (classDirectory != null) {
            return classDirectory;
        }
        try {
            return PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)"", null, (boolean)false);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private String getUniqueName() {
        return new UniqueNameGenerator((Collection)EjbCommonModelUtil.getAllEjbs((Project)this.myModule.getProject(), (Module)this.myModule, null), (Function)ElementPresentationManager.NAMER()).generateUniqueName(this.getDefaultName(), this.ejbType.getNamePrefix(this.myCodeStyleSettings), this.ejbType.getNameSuffix(this.myCodeStyleSettings));
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    public String getPackage() {
        return ClassUtil.extractPackageName((String)this.getClassName());
    }

    public String getPureName() {
        String result = this.getName();
        String namePrefix = this.ejbType.getNamePrefix(this.myCodeStyleSettings);
        result = StringUtil.trimStart((String)result, (String)namePrefix);
        String nameSuffix = this.ejbType.getNameSuffix(this.myCodeStyleSettings);
        result = StringUtil.trimEnd((String)result, (String)nameSuffix);
        return result;
    }

    public boolean checkNameIsUnique() {
        String name = this.getName();
        if (Comparing.equal((String)this.myOldName, (String)name)) {
            return true;
        }
        for (EnterpriseBean enterpriseBean : EjbCommonModelUtil.getAllEjbs((Project)this.myModule.getProject(), (Module)this.myModule, null)) {
            String anotherName = (String)enterpriseBean.getEjbName().getValue();
            if (Comparing.equal((String)anotherName, (String)this.myOldName) || !Comparing.equal((String)anotherName, (String)name)) continue;
            return false;
        }
        return true;
    }

    public void setCmpVersion(CmpVersion cmpVersion) {
        this.myCmpVersion = cmpVersion;
    }

    @Nullable
    public String getRemoteInterfaceName() {
        return this.generateRemote ? this.remoteInterfaceName : null;
    }

    public void setRemoteInterfaceName(String remoteInterfaceName) {
        this.remoteInterfaceName = remoteInterfaceName;
    }

    @Nullable
    public String getRemoteHomeInterfaceName() {
        return this.generateRemote ? this.remoteHomeInterfaceName : null;
    }

    public void setRemoteHomeInterfaceName(String remoteHomeInterfaceName) {
        this.remoteHomeInterfaceName = remoteHomeInterfaceName;
    }

    public boolean isGenerateRemote() {
        return this.generateRemote;
    }

    public void setGenerateRemote(boolean generateRemote) {
        this.generateRemote = generateRemote;
    }

    @Nullable
    public String getLocalInterfaceName() {
        return this.generateLocal ? this.localInterfaceName : null;
    }

    public void setLocalInterfaceName(String localInterfaceName) {
        this.localInterfaceName = localInterfaceName;
    }

    @Nullable
    public String getLocalHomeInterfaceName() {
        return this.generateLocal ? this.localHomeInterfaceName : null;
    }

    public void setLocalHomeInterfaceName(String localHomeInterfaceName) {
        this.localHomeInterfaceName = localHomeInterfaceName;
    }

    public boolean isGenerateLocal() {
        return this.generateLocal;
    }

    public void setGenerateLocal(boolean generateLocal) {
        this.generateLocal = generateLocal;
    }

    public boolean isGenerateServiceEndpoint() {
        return this.myGenerateServiceEndpoint;
    }

    public void setGenerateServiceEndpoint(boolean generateServiceEndpoint) {
        this.myGenerateServiceEndpoint = generateServiceEndpoint;
    }

    public EjbType getEjbType() {
        return this.ejbType;
    }

    public void setEjbType(EjbType ejbType) {
        this.ejbType = ejbType;
    }

    public PersistenceType getPersistenceType() {
        return this.myPersistenceType;
    }

    public String getPKClassName() {
        return this.myPkClassName;
    }

    public void setPkClassName(String primaryKeyClassName) {
        this.myPkClassName = primaryKeyClassName;
    }

    public CmpVersion getCmpVersion() {
        return this.myCmpVersion;
    }

    @NonNls
    private static String getDefaultName(EjbType type) {
        return type.toString();
    }

    private String getDefaultName() {
        return EjbDataHolder.getDefaultName(this.ejbType);
    }

    public static String composeEjbFullname(EjbType ejbType, JavaeeCodeStyleSettings codeStyleSettings, String name) {
        return (ejbType == EjbType.Entity ? codeStyleSettings.ENTITY_DD_PREFIX : codeStyleSettings.SESSION_DD_PREFIX) + name + (ejbType == EjbType.Entity ? codeStyleSettings.ENTITY_DD_SUFFIX : codeStyleSettings.SESSION_DD_SUFFIX);
    }

    public void setPackage(String qualifiedName) {
        this.myClassName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.myClassName);
        this.remoteHomeInterfaceName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.remoteHomeInterfaceName);
        this.remoteInterfaceName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.remoteInterfaceName);
        this.localInterfaceName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.localInterfaceName);
        this.localHomeInterfaceName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.localHomeInterfaceName);
        this.myServiceEndpointInterface = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.myServiceEndpointInterface);
        PsiClass pkClass = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findClass(this.myPkClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (!(pkClass instanceof PsiCompiledElement)) {
            this.myPkClassName = ClassUtil.createNewClassQualifiedName((String)qualifiedName, (String)this.myPkClassName);
        }
    }

    @NonNls
    public String createPrimaryKeyClassName() {
        return this.getPureName() + "PK";
    }

    @Nullable
    public EjbFacet getEjbFacet() {
        return this.myEjbFacet;
    }

    public final SessionType getSessionType() {
        return this.mySessionType;
    }

    public String getMessageListenerInterface() {
        return this.myMessageListenerInterface;
    }

    public void setMessageListenerInterface(String messageListenerInterface) {
        this.myMessageListenerInterface = StringUtil.isEmpty((String)messageListenerInterface) ? null : messageListenerInterface;
    }

    public String getServiceEndpointInterface() {
        return this.myGenerateServiceEndpoint ? this.myServiceEndpointInterface : null;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.myServiceEndpointInterface = StringUtil.isEmpty((String)serviceEndpointInterface) ? null : serviceEndpointInterface;
    }
}

