/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class EjbAllOverridingMethodSearcher
implements QueryExecutor<Couple<PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, @NotNull Processor<Couple<PsiMethod>> consumer) {
        PsiMethod[] methods;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/javaee/EjbAllOverridingMethodSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/EjbAllOverridingMethodSearcher", "execute"));
        }
        for (PsiMethod method : methods = p.getPsiClass().getMethods()) {
            for (EjbMethodRole ejbRole : OldEjbRolesUtil.getEjbRoles(method)) {
                PsiMethod[] implementations;
                if (!(ejbRole instanceof EjbDeclMethodRoleImpl)) continue;
                for (PsiMethod implementation : implementations = ((EjbDeclMethodRole)ejbRole).findImplementationsInEjbClass()) {
                    if (implementation.getContainingClass().isInheritor(method.getContainingClass(), true) && implementation.getSignature(PsiSubstitutor.EMPTY).equals(method.getSignature(PsiSubstitutor.EMPTY)) || consumer.process((Object)Couple.of((Object)method, (Object)implementation))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

