/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web;

import com.intellij.facet.FacetTypeId;
import com.intellij.j2ee.JavaeeCachesUtil;
import com.intellij.j2ee.web.filter.role.FilterClassRole;
import com.intellij.j2ee.web.servlet.role.ServletClassRole;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.Nullable;

public class WebRolesUtil {
    private static final JavaeeCachesUtil.CachedValueProviderProvider<ServletClassRole, PsiElement> SERVLET_ROLE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<ServletClassRole, PsiElement>(){

        @Override
        public CachedValueProvider<ServletClassRole> createProvider(PsiElement psiElement) {
            return new MyServletRoleProvider((PsiClass)psiElement);
        }
    };
    private static final JavaeeCachesUtil.CachedValueProviderProvider<FilterClassRole, PsiElement> FILTER_ROLE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<FilterClassRole, PsiElement>(){

        @Override
        public CachedValueProvider<FilterClassRole> createProvider(PsiElement psiElement) {
            return new MyFilterRoleProvider((PsiClass)psiElement);
        }
    };

    private WebRolesUtil() {
    }

    @Nullable
    public static ServletClassRole getServletRole(PsiClass servletClass) {
        return JavaeeCachesUtil.getJavaeeValue((PsiElement)servletClass, SERVLET_ROLE_PROVIDER_PROVIDER, (FacetTypeId<? extends JavaeeFacet>)WebFacet.ID);
    }

    @Nullable
    public static FilterClassRole getFilterRole(PsiClass filterClass) {
        return JavaeeCachesUtil.getJavaeeValue((PsiElement)filterClass, FILTER_ROLE_PROVIDER_PROVIDER, (FacetTypeId<? extends JavaeeFacet>)WebFacet.ID);
    }

    private static class MyFilterRoleProvider
    implements CachedValueProvider<FilterClassRole> {
        private final PsiClass myPsiClass;

        MyFilterRoleProvider(PsiClass psiClass) {
            this.myPsiClass = psiClass;
        }

        public CachedValueProvider.Result<FilterClassRole> compute() {
            FilterClassRole role;
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)this.myPsiClass);
            if (webFacet != null && (role = FilterClassRole.getClassRole(this.myPsiClass, webFacet.getRoot())) != null) {
                return new CachedValueProvider.Result((Object)role, JavaeeCachesUtil.getDependencyItems(webFacet.getWebXmlDescriptor()));
            }
            return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }

    private static class MyServletRoleProvider
    implements CachedValueProvider<ServletClassRole> {
        private final PsiClass myPsiClass;

        MyServletRoleProvider(PsiClass psiClass) {
            this.myPsiClass = psiClass;
        }

        public CachedValueProvider.Result<ServletClassRole> compute() {
            ServletClassRole role;
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)this.myPsiClass);
            if (webFacet != null && (role = ServletClassRole.getClassRole(this.myPsiClass, webFacet.getRoot())) != null) {
                return new CachedValueProvider.Result((Object)role, JavaeeCachesUtil.getDependencyItems(webFacet.getWebXmlDescriptor()));
            }
            return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }
}

